/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.natives.compression.java;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import net.shieldcommunity.nullcordx.natives.ByteBufAllocationUtils;
import net.shieldcommunity.nullcordx.natives.compression.Compressor;

public class JavaCompressor
implements Compressor {
    private final Deflater deflater;
    private boolean closed = false;

    public JavaCompressor(int level) {
        this.deflater = new Deflater(level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deflate(ByteBuf source, ByteBuf destination) throws DataFormatException {
        Preconditions.checkState(!this.closed, "Compressor already closed");
        Preconditions.checkArgument(source.nioBufferCount() == 1, "source has multiple backing buffers");
        Preconditions.checkArgument(destination.nioBufferCount() == 1, "destination has multiple backing buffers");
        try {
            byte[] inData = new byte[source.readableBytes()];
            source.readBytes(inData);
            this.deflater.setInput(inData);
            this.deflater.finish();
            byte[] buffer = ByteBufAllocationUtils.ZLIB_DEFAULT_BUFFER.get();
            while (!this.deflater.finished()) {
                int count = this.deflater.deflate(buffer);
                destination.writeBytes(buffer, 0, count);
            }
        }
        finally {
            this.deflater.reset();
        }
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.deflater.end();
        }
        this.closed = true;
    }

    @Override
    public boolean isNeedDirectBuffer() {
        return false;
    }
}

