/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.natives.compression.libdeflate;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.util.zip.DataFormatException;
import net.shieldcommunity.nullcordx.natives.compression.Compressor;
import net.shieldcommunity.nullcordx.natives.compression.jni.NativeLibdeflateDeflate;

public class LibdeflateCompressor
implements Compressor {
    private final long deflateCtx;
    private boolean closed = false;

    public LibdeflateCompressor(int level) {
        int correctedLevel;
        int n = correctedLevel = level == -1 ? 6 : level;
        if (correctedLevel > 12 || correctedLevel < 1) {
            throw new IllegalArgumentException("Invalid compression level " + level);
        }
        this.deflateCtx = NativeLibdeflateDeflate.init(correctedLevel);
    }

    @Override
    public void deflate(ByteBuf source, ByteBuf destination) throws DataFormatException {
        int produced;
        block1: {
            Preconditions.checkState(!this.closed, "Compressor already closed");
            while (true) {
                long sourceAddress = source.memoryAddress() + (long)source.readerIndex();
                long destinationAddress = destination.memoryAddress() + (long)destination.writerIndex();
                produced = NativeLibdeflateDeflate.process(this.deflateCtx, sourceAddress, source.readableBytes(), destinationAddress, destination.writableBytes());
                if (produced > 0) break block1;
                if (produced != 0) break;
                destination.capacity(destination.capacity() * 2);
            }
            throw new DataFormatException("libdeflate returned unknown code " + produced);
        }
        destination.writerIndex(destination.writerIndex() + produced);
    }

    @Override
    public void close() {
        if (!this.closed) {
            NativeLibdeflateDeflate.close(this.deflateCtx);
        }
        this.closed = true;
    }

    @Override
    public boolean isNeedDirectBuffer() {
        return true;
    }
}

