/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.LongAdder;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.shieldcommunity.nullcordx.netty.PacketLimit;
import net.shieldcommunity.nullcordx.tasks.ScheduledCounter;

public class ChannelStatisticsAndPacketLimiterUpstreamHandler
extends ChannelDuplexHandler {
    private int packetBytesPerSecond = 0;
    private int packetsSentPerSecond = 0;
    private int lastSecond = -1;
    private PacketLimit packetLimit = null;
    private ProxiedPlayer connection;
    public static final LongAdder OPENED_CONNECTIONS = new LongAdder();

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        OPENED_CONNECTIONS.increment();
        super.channelActive(ctx);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        OPENED_CONNECTIONS.decrement();
        super.channelInactive(ctx);
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object object) throws Exception {
        if (object instanceof ByteBuf) {
            ByteBuf buf = (ByteBuf)object;
            BungeeCord.getInstance().getNullCordX().getStatisticsManager().getUpstreamNetworkStatistics().addChannelReadPerSecond(buf.readableBytes());
            if (!this.checkPacketLimit(ctx, buf)) {
                buf.release();
                return;
            }
        }
        super.channelRead(ctx, object);
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object object, ChannelPromise promise) throws Exception {
        if (object instanceof ByteBuf) {
            ByteBuf buf = (ByteBuf)object;
            BungeeCord.getInstance().getNullCordX().getStatisticsManager().getUpstreamNetworkStatistics().addChannelWritePerSecond(buf.readableBytes());
        }
        super.write(ctx, object, promise);
    }

    private boolean checkPacketLimit(ChannelHandlerContext ctx, ByteBuf buf) {
        int packetLength;
        PacketLimit packetLimit = this.packetLimit;
        if (packetLimit == null) {
            return true;
        }
        ScheduledCounter scheduledCounter = ScheduledCounter.getInstance();
        if (scheduledCounter == null) {
            return true;
        }
        int currentSecond = scheduledCounter.getCurrentSecond();
        if (currentSecond != this.lastSecond) {
            this.lastSecond = currentSecond;
            this.packetsSentPerSecond = 0;
            this.packetBytesPerSecond = 0;
        }
        if ((packetLength = buf.readableBytes()) > packetLimit.getMaxBytes()) {
            this.closeConnection(ctx, this.getConnectionName(ctx) + " sent a packet exceeding the limit of " + packetLimit.getMaxBytes() + " bytes");
            return false;
        }
        if ((this.packetBytesPerSecond += packetLength) > packetLimit.getMaxPacketBytesPerSecond()) {
            this.closeConnection(ctx, this.getConnectionName(ctx) + " reached the limit of " + packetLimit.getMaxPacketBytesPerSecond() + " bytes per second");
            return false;
        }
        if (++this.packetsSentPerSecond > packetLimit.getMaxPacketsSentPerSecond()) {
            this.closeConnection(ctx, this.getConnectionName(ctx) + " reached the limit of " + packetLimit.getMaxPacketsSentPerSecond() + " packet per second");
            return false;
        }
        return true;
    }

    private String getConnectionName(ChannelHandlerContext ctx) {
        String name = null;
        ProxiedPlayer connection = this.connection;
        if (connection != null) {
            name = connection.getName();
        }
        if (name == null) {
            name = ((InetSocketAddress)ctx.channel().remoteAddress()).getAddress().getHostAddress();
        }
        return name;
    }

    private void closeConnection(ChannelHandlerContext ctx, String message) {
        ProxiedPlayer connection = this.connection;
        if (connection != null) {
            connection.forceClose(message);
            return;
        }
        ctx.close();
    }

    public PacketLimit getPacketLimit() {
        return this.packetLimit;
    }

    public void setPacketLimit(PacketLimit packetLimit) {
        this.packetLimit = packetLimit;
    }

    public ProxiedPlayer getConnection() {
        return this.connection;
    }

    public void setConnection(ProxiedPlayer connection) {
        this.connection = connection;
    }
}

