/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.protocol;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;

public enum ProtocolBlockType {
    AIR(0.0),
    STONE(1.0),
    OAK_SLAB(0.5),
    OAK_TRAPDOOR(0.1875),
    OAK_FENCE(1.5),
    OAK_PRESSURE_PLATE(0.0),
    IRON_TRAPDOOR(0.1875),
    DAYLIGHT_DETECTOR(0.375),
    PORTAL_FRAME(0.8125),
    SNOW_LAYER_1(0.0),
    SNOW_LAYER_2(0.125),
    SNOW_LAYER_3(0.25),
    SNOW_LAYER_4(0.375),
    SNOW_LAYER_5(0.5),
    SNOW_LAYER_6(0.625),
    SNOW_LAYER_7(0.75),
    SNOW_LAYER_8(0.875),
    WHITE_CARPET(0.0625),
    ORANGE_CARPET(0.0625),
    MAGENTA_CARPET(0.0625),
    LIGHT_BLUE_CARPET(0.0625),
    YELLOW_CARPET(0.0625),
    LIME_CARPET(0.0625),
    PINK_CARPET(0.0625),
    GRAY_CARPET(0.0625),
    LIGHT_GRAY_CARPET(0.0625),
    CYAN_CARPET(0.0625),
    PURPLE_CARPET(0.0625),
    BLUE_CARPET(0.0625),
    BROWN_CARPET(0.0625),
    GREEN_CARPET(0.0625),
    RED_CARPET(0.0625),
    BLACK_CARPET(0.0625),
    FARMLAND(0.9375),
    ENCHANTING_TABLE(0.75),
    CHEST(0.875),
    ENDER_CHEST(0.875),
    SKELETON_SKULL(0.5);

    private final double height;
    private Map<Integer, Integer> mappings;

    public int getIdByProtocol(int version) {
        Integer id = this.mappings.get(version);
        if (id == null) {
            throw new IllegalStateException("Mappings with version " + version + " for type " + this.name() + " does not exists!");
        }
        return id;
    }

    public static Set<ProtocolBlockType> getDefaultBlocks() {
        return new HashSet<ProtocolBlockType>(Arrays.asList(AIR, STONE, OAK_SLAB, OAK_TRAPDOOR, DAYLIGHT_DETECTOR, PORTAL_FRAME, SNOW_LAYER_1, SNOW_LAYER_2, SNOW_LAYER_3, SNOW_LAYER_4, SNOW_LAYER_5, SNOW_LAYER_6, SNOW_LAYER_7, SNOW_LAYER_8, WHITE_CARPET, FARMLAND, ENCHANTING_TABLE, CHEST));
    }

    private ProtocolBlockType(double height) {
        this.height = height;
    }

    public double getHeight() {
        return this.height;
    }

    public Map<Integer, Integer> getMappings() {
        return this.mappings;
    }

    static {
        try (JsonReader reader = new Gson().newJsonReader(new InputStreamReader(ProtocolBlockType.class.getResourceAsStream("/block_states.json"), StandardCharsets.UTF_8));){
            JsonElement element = JsonParser.parseReader(reader);
            JsonObject jsonObject = element.getAsJsonObject();
            for (ProtocolBlockType type : ProtocolBlockType.values()) {
                JsonElement e = jsonObject.get(type.name());
                if (e == null) {
                    throw new IllegalStateException("Failed to find " + type.name() + " in block mappings!");
                }
                Int2ObjectOpenHashMap<Integer> idByProtocol = new Int2ObjectOpenHashMap<Integer>();
                JsonObject elementObject = e.getAsJsonObject();
                Set<String> keys = elementObject.keySet();
                for (String key : keys) {
                    idByProtocol.put(Integer.valueOf(Integer.parseInt(key)), Integer.valueOf(elementObject.get(key).getAsInt()));
                }
                Iterator<Object> iterator = ProtocolConstants.SUPPORTED_VERSION_IDS.iterator();
                while (iterator.hasNext()) {
                    int protocol = (Integer)iterator.next();
                    Integer id = (Integer)idByProtocol.get((Object)protocol);
                    if (id == null) {
                        throw new IllegalStateException("Failed to find protocol version " + protocol + " for " + type.name() + " in block mappings!");
                    }
                    idByProtocol.put(Integer.valueOf(protocol), id);
                }
                type.mappings = idByProtocol;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

