/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.protocol;

public enum ProtocolItemFrameRotationType {
    UP(0),
    RIGHT(1),
    DOWN(2),
    LEFT(3);

    private final int rotation;
    private ProtocolItemFrameRotationType nextRotation;
    private ProtocolItemFrameRotationType prevRotation;

    public static ProtocolItemFrameRotationType degreesToType(int degrees2) {
        switch (degrees2) {
            case 90: {
                return RIGHT;
            }
            case 180: {
                return DOWN;
            }
            case 270: {
                return LEFT;
            }
        }
        return UP;
    }

    public static ProtocolItemFrameRotationType findRotation(ProtocolItemFrameRotationType type) {
        switch (type) {
            case LEFT: {
                return RIGHT;
            }
            case DOWN: {
                return DOWN;
            }
            case RIGHT: {
                return LEFT;
            }
        }
        return UP;
    }

    public static ProtocolItemFrameRotationType findRotation(int rotation) {
        for (ProtocolItemFrameRotationType type : ProtocolItemFrameRotationType.values()) {
            if (type.getRotation() != rotation) continue;
            return type;
        }
        return null;
    }

    private ProtocolItemFrameRotationType(int rotation) {
        this.rotation = rotation;
    }

    public int getRotation() {
        return this.rotation;
    }

    public ProtocolItemFrameRotationType getNextRotation() {
        return this.nextRotation;
    }

    public ProtocolItemFrameRotationType getPrevRotation() {
        return this.prevRotation;
    }

    static {
        ProtocolItemFrameRotationType.UP.nextRotation = RIGHT;
        ProtocolItemFrameRotationType.UP.prevRotation = LEFT;
        ProtocolItemFrameRotationType.RIGHT.nextRotation = DOWN;
        ProtocolItemFrameRotationType.RIGHT.prevRotation = UP;
        ProtocolItemFrameRotationType.DOWN.nextRotation = LEFT;
        ProtocolItemFrameRotationType.DOWN.prevRotation = RIGHT;
        ProtocolItemFrameRotationType.LEFT.nextRotation = UP;
        ProtocolItemFrameRotationType.LEFT.prevRotation = DOWN;
    }
}

