/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.protocol;

import io.netty.buffer.ByteBuf;

public final class ProtocolPosition {
    private final int x;
    private final int y;
    private final int z;

    public void write(ByteBuf buf, int version) {
        if (version > 404) {
            buf.writeLong(ProtocolPosition.encodePosition(this.x, this.y, this.z));
        } else {
            buf.writeLong(ProtocolPosition.encodePosition_1_8(this.x, this.y, this.z));
        }
    }

    private static long encodePosition(long x, long y, long z) {
        return (x & 0x3FFFFFFL) << 38 | (z & 0x3FFFFFFL) << 12 | y & 0xFFFL;
    }

    private static long encodePosition_1_8(long x, long y, long z) {
        return (x & 0x3FFFFFFL) << 38 | (y & 0xFFFL) << 26 | z & 0x3FFFFFFL;
    }

    public ProtocolPosition(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProtocolPosition)) {
            return false;
        }
        ProtocolPosition other = (ProtocolPosition)o;
        if (this.getX() != other.getX()) {
            return false;
        }
        if (this.getY() != other.getY()) {
            return false;
        }
        return this.getZ() == other.getZ();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getX();
        result = result * 59 + this.getY();
        result = result * 59 + this.getZ();
        return result;
    }

    public String toString() {
        return "ProtocolPosition(x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ")";
    }
}

