/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.protocol.packets;

import io.netty.buffer.ByteBuf;
import java.util.BitSet;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;
import se.llbit.nbt.CompoundTag;
import se.llbit.nbt.LongArrayTag;
import se.llbit.nbt.NamedTag;

public class EmptyChunkPacket
extends DefinedPacket {
    private int x;
    private int z;

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int version) {
        buf.writeInt(this.x);
        buf.writeInt(this.z);
        if (version < 755) {
            buf.writeBoolean(true);
        }
        if (version >= 735 && version < 751) {
            buf.writeBoolean(true);
        }
        if (version < 755) {
            if (version == 47) {
                buf.writeShort(1);
            } else {
                EmptyChunkPacket.writeVarInt(0, buf);
            }
        } else if (version < 757) {
            BitSet bitSet = new BitSet();
            for (int i = 0; i < 16; ++i) {
                bitSet.set(i, false);
            }
            long[] mask = bitSet.toLongArray();
            EmptyChunkPacket.writeVarInt(mask.length, buf);
            for (long l : mask) {
                buf.writeLong(l);
            }
        }
        if (version >= 477) {
            EmptyChunkPacket.write1_14Heightmaps(buf, version);
            if (version >= 573 && version < 757) {
                if (version >= 751) {
                    EmptyChunkPacket.writeVarInt(1024, buf);
                    for (int i = 0; i < 1024; ++i) {
                        EmptyChunkPacket.writeVarInt(1, buf);
                    }
                } else {
                    for (int i = 0; i < 1024; ++i) {
                        buf.writeInt(0);
                    }
                }
            }
        }
        if (version < 393) {
            EmptyChunkPacket.writeArray(new byte[256], buf);
        } else if (version < 573) {
            EmptyChunkPacket.writeArray(new byte[1024], buf);
        } else if (version < 757) {
            EmptyChunkPacket.writeVarInt(0, buf);
        } else {
            byte[] sectionData = new byte[]{0, 0, 0, 0, 0, 0, 1, 0};
            EmptyChunkPacket.writeVarInt(sectionData.length * 16, buf);
            for (int i = 0; i < 16; ++i) {
                buf.writeBytes(sectionData);
            }
        }
        if (version >= 110) {
            EmptyChunkPacket.writeVarInt(0, buf);
        }
        if (version >= 757) {
            byte[] lightData = new byte[]{1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 3, -1, -1, 0, 0};
            buf.ensureWritable(lightData.length);
            if (version >= 763) {
                buf.writeBytes(lightData, 1, lightData.length - 1);
            } else {
                buf.writeBytes(lightData);
            }
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        throw new UnsupportedOperationException();
    }

    private static void write1_14Heightmaps(ByteBuf buf, int version) {
        long[] arrayData = new long[version < 757 ? 36 : 37];
        LongArrayTag longArrayTag = new LongArrayTag(arrayData);
        CompoundTag tag = new CompoundTag();
        tag.add("MOTION_BLOCKING", longArrayTag);
        CompoundTag rootTag = new CompoundTag();
        rootTag.add("root", tag);
        if (version >= 764) {
            EmptyChunkPacket.writeNamelessTag(rootTag, buf);
        } else {
            EmptyChunkPacket.writeTag(new NamedTag("", rootTag), buf, version);
        }
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setZ(int z) {
        this.z = z;
    }

    @Override
    public String toString() {
        return "EmptyChunkPacket(x=" + this.getX() + ", z=" + this.getZ() + ")";
    }

    public EmptyChunkPacket() {
    }

    public EmptyChunkPacket(int x, int z) {
        this.x = x;
        this.z = z;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EmptyChunkPacket)) {
            return false;
        }
        EmptyChunkPacket other = (EmptyChunkPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getX() != other.getX()) {
            return false;
        }
        return this.getZ() == other.getZ();
    }

    protected boolean canEqual(Object other) {
        return other instanceof EmptyChunkPacket;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getX();
        result = result * 59 + this.getZ();
        return result;
    }
}

