/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.protocol.packets;

import io.netty.buffer.ByteBuf;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.shieldcommunity.nullcordx.protocol.ProtocolEffectType;

public class EntityEffectPacket
extends DefinedPacket {
    private int entityId;
    private ProtocolEffectType effectType;
    private byte amplifier;
    private int duration;
    private boolean ambient;
    private boolean showParticles;
    private boolean showIcon;
    private static final int FLAG_AMBIENT = 1;
    private static final int FLAG_SHOW_PARTICLES = 2;
    private static final int FLAG_SHOW_ICON = 4;

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        EntityEffectPacket.writeVarInt(this.entityId, buf);
        if (protocolVersion > 756) {
            EntityEffectPacket.writeVarInt(this.effectType.getEffectIdByProtocol(protocolVersion), buf);
        } else {
            buf.writeByte(this.effectType.getEffectIdByProtocol(protocolVersion));
        }
        buf.writeByte(this.amplifier);
        EntityEffectPacket.writeVarInt(this.duration, buf);
        if (protocolVersion > 47) {
            int flags = 0;
            if (this.ambient) {
                flags |= 1;
            }
            if (this.showParticles) {
                flags |= 2;
            }
            if (this.showIcon) {
                flags |= 4;
            }
            buf.writeByte(flags);
        } else {
            buf.writeBoolean(this.showParticles);
        }
        if (protocolVersion > 758) {
            buf.writeBoolean(false);
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        throw new UnsupportedOperationException();
    }

    public int getEntityId() {
        return this.entityId;
    }

    public ProtocolEffectType getEffectType() {
        return this.effectType;
    }

    public byte getAmplifier() {
        return this.amplifier;
    }

    public int getDuration() {
        return this.duration;
    }

    public boolean isAmbient() {
        return this.ambient;
    }

    public boolean isShowParticles() {
        return this.showParticles;
    }

    public boolean isShowIcon() {
        return this.showIcon;
    }

    public void setEntityId(int entityId) {
        this.entityId = entityId;
    }

    public void setEffectType(ProtocolEffectType effectType) {
        this.effectType = effectType;
    }

    public void setAmplifier(byte amplifier) {
        this.amplifier = amplifier;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public void setAmbient(boolean ambient) {
        this.ambient = ambient;
    }

    public void setShowParticles(boolean showParticles) {
        this.showParticles = showParticles;
    }

    public void setShowIcon(boolean showIcon) {
        this.showIcon = showIcon;
    }

    @Override
    public String toString() {
        return "EntityEffectPacket(entityId=" + this.getEntityId() + ", effectType=" + this.getEffectType() + ", amplifier=" + this.getAmplifier() + ", duration=" + this.getDuration() + ", ambient=" + this.isAmbient() + ", showParticles=" + this.isShowParticles() + ", showIcon=" + this.isShowIcon() + ")";
    }

    public EntityEffectPacket() {
    }

    public EntityEffectPacket(int entityId, ProtocolEffectType effectType, byte amplifier, int duration, boolean ambient, boolean showParticles, boolean showIcon) {
        this.entityId = entityId;
        this.effectType = effectType;
        this.amplifier = amplifier;
        this.duration = duration;
        this.ambient = ambient;
        this.showParticles = showParticles;
        this.showIcon = showIcon;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityEffectPacket)) {
            return false;
        }
        EntityEffectPacket other = (EntityEffectPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        if (this.getAmplifier() != other.getAmplifier()) {
            return false;
        }
        if (this.getDuration() != other.getDuration()) {
            return false;
        }
        if (this.isAmbient() != other.isAmbient()) {
            return false;
        }
        if (this.isShowParticles() != other.isShowParticles()) {
            return false;
        }
        if (this.isShowIcon() != other.isShowIcon()) {
            return false;
        }
        ProtocolEffectType this$effectType = this.getEffectType();
        ProtocolEffectType other$effectType = other.getEffectType();
        return !(this$effectType == null ? other$effectType != null : !((Object)((Object)this$effectType)).equals((Object)other$effectType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EntityEffectPacket;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        result = result * 59 + this.getAmplifier();
        result = result * 59 + this.getDuration();
        result = result * 59 + (this.isAmbient() ? 79 : 97);
        result = result * 59 + (this.isShowParticles() ? 79 : 97);
        result = result * 59 + (this.isShowIcon() ? 79 : 97);
        ProtocolEffectType $effectType = this.getEffectType();
        result = result * 59 + ($effectType == null ? 43 : ((Object)((Object)$effectType)).hashCode());
        return result;
    }
}

