/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.protocol.packets;

import io.netty.buffer.ByteBuf;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.shieldcommunity.nullcordx.protocol.ProtocolGameEventReason;
import net.shieldcommunity.nullcordx.protocol.ProtocolGameEventValue;

public class GameEventPacket
extends DefinedPacket {
    private ProtocolGameEventReason reason;
    private ProtocolGameEventValue value;

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int version) {
        buf.writeByte(this.reason.getProtocolReasonByVersion(version));
        buf.writeFloat(this.value != null ? this.value.getProtocolGameEventValueByVersion(version) : 0.0f);
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        throw new UnsupportedOperationException();
    }

    public ProtocolGameEventReason getReason() {
        return this.reason;
    }

    public ProtocolGameEventValue getValue() {
        return this.value;
    }

    public void setReason(ProtocolGameEventReason reason) {
        this.reason = reason;
    }

    public void setValue(ProtocolGameEventValue value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return "GameEventPacket(reason=" + this.getReason() + ", value=" + this.getValue() + ")";
    }

    public GameEventPacket() {
    }

    public GameEventPacket(ProtocolGameEventReason reason, ProtocolGameEventValue value) {
        this.reason = reason;
        this.value = value;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GameEventPacket)) {
            return false;
        }
        GameEventPacket other = (GameEventPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ProtocolGameEventReason this$reason = this.getReason();
        ProtocolGameEventReason other$reason = other.getReason();
        if (this$reason == null ? other$reason != null : !((Object)((Object)this$reason)).equals((Object)other$reason)) {
            return false;
        }
        ProtocolGameEventValue this$value = this.getValue();
        ProtocolGameEventValue other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GameEventPacket;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ProtocolGameEventReason $reason = this.getReason();
        result = result * 59 + ($reason == null ? 43 : ((Object)((Object)$reason)).hashCode());
        ProtocolGameEventValue $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }
}

