/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.protocol.packets;

import io.netty.buffer.ByteBuf;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.shieldcommunity.nullcordx.protocol.ProtocolMapData;

public class MapDataPacket
extends DefinedPacket {
    private int mapId;
    private byte scale;
    private ProtocolMapData protocolMapData;

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        this.writeCommonData(buf, protocolVersion);
        this.writePixels(buf, protocolVersion);
    }

    public void writeCommonData(ByteBuf buf, int protocolVersion) {
        MapDataPacket.writeVarInt(this.mapId, buf);
        buf.writeByte(this.scale);
        if (protocolVersion >= 107 && protocolVersion < 755) {
            buf.writeBoolean(false);
        }
        if (protocolVersion >= 477) {
            buf.writeBoolean(false);
        }
        if (protocolVersion >= 755) {
            buf.writeBoolean(false);
        } else {
            MapDataPacket.writeVarInt(0, buf);
        }
        buf.writeByte(this.protocolMapData.getColumns());
        buf.writeByte(this.protocolMapData.getRows());
        buf.writeByte(this.protocolMapData.getX());
        buf.writeByte(this.protocolMapData.getY());
    }

    public void writePixels(ByteBuf buf, int protocolVersion) {
        byte[] pixels = this.protocolMapData.getPerVersionMapData().getMapDataByVersion(protocolVersion);
        buf.ensureWritable(3 + pixels.length);
        MapDataPacket.writeArray(pixels, buf);
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        throw new UnsupportedOperationException();
    }

    public int getMapId() {
        return this.mapId;
    }

    public byte getScale() {
        return this.scale;
    }

    public ProtocolMapData getProtocolMapData() {
        return this.protocolMapData;
    }

    public void setMapId(int mapId) {
        this.mapId = mapId;
    }

    public void setScale(byte scale) {
        this.scale = scale;
    }

    public void setProtocolMapData(ProtocolMapData protocolMapData) {
        this.protocolMapData = protocolMapData;
    }

    @Override
    public String toString() {
        return "MapDataPacket(mapId=" + this.getMapId() + ", scale=" + this.getScale() + ", protocolMapData=" + this.getProtocolMapData() + ")";
    }

    public MapDataPacket() {
    }

    public MapDataPacket(int mapId, byte scale, ProtocolMapData protocolMapData) {
        this.mapId = mapId;
        this.scale = scale;
        this.protocolMapData = protocolMapData;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MapDataPacket)) {
            return false;
        }
        MapDataPacket other = (MapDataPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMapId() != other.getMapId()) {
            return false;
        }
        if (this.getScale() != other.getScale()) {
            return false;
        }
        ProtocolMapData this$protocolMapData = this.getProtocolMapData();
        ProtocolMapData other$protocolMapData = other.getProtocolMapData();
        return !(this$protocolMapData == null ? other$protocolMapData != null : !((Object)this$protocolMapData).equals(other$protocolMapData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MapDataPacket;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMapId();
        result = result * 59 + this.getScale();
        ProtocolMapData $protocolMapData = this.getProtocolMapData();
        result = result * 59 + ($protocolMapData == null ? 43 : ((Object)$protocolMapData).hashCode());
        return result;
    }
}

