/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.protocol.packets;

import io.netty.buffer.ByteBuf;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.shieldcommunity.nullcordx.protocol.SlotData;

public class SetSlotPacket
extends DefinedPacket {
    private int windowId;
    private int slot;
    private SlotData slotData;

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int version) {
        buf.writeByte(this.windowId);
        if (version >= 756) {
            SetSlotPacket.writeVarInt(0, buf);
        }
        buf.writeShort(this.slot);
        this.slotData.writeMetadata(buf, version);
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        throw new UnsupportedOperationException();
    }

    public int getWindowId() {
        return this.windowId;
    }

    public int getSlot() {
        return this.slot;
    }

    public SlotData getSlotData() {
        return this.slotData;
    }

    public void setWindowId(int windowId) {
        this.windowId = windowId;
    }

    public void setSlot(int slot) {
        this.slot = slot;
    }

    public void setSlotData(SlotData slotData) {
        this.slotData = slotData;
    }

    @Override
    public String toString() {
        return "SetSlotPacket(windowId=" + this.getWindowId() + ", slot=" + this.getSlot() + ", slotData=" + this.getSlotData() + ")";
    }

    public SetSlotPacket() {
    }

    public SetSlotPacket(int windowId, int slot, SlotData slotData) {
        this.windowId = windowId;
        this.slot = slot;
        this.slotData = slotData;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SetSlotPacket)) {
            return false;
        }
        SetSlotPacket other = (SetSlotPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getWindowId() != other.getWindowId()) {
            return false;
        }
        if (this.getSlot() != other.getSlot()) {
            return false;
        }
        SlotData this$slotData = this.getSlotData();
        SlotData other$slotData = other.getSlotData();
        return !(this$slotData == null ? other$slotData != null : !this$slotData.equals(other$slotData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SetSlotPacket;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getWindowId();
        result = result * 59 + this.getSlot();
        SlotData $slotData = this.getSlotData();
        result = result * 59 + ($slotData == null ? 43 : $slotData.hashCode());
        return result;
    }
}

