/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.protocol.packets;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.shieldcommunity.nullcordx.protocol.ProtocolRelativePositionType;

public class SynchronizePlayerPositionPacket
extends DefinedPacket {
    private double x;
    private double y;
    private double z;
    private float yaw;
    private float pitch;
    private int teleportId;
    private ProtocolRelativePositionType[] relative;

    public SynchronizePlayerPositionPacket(double x, double y, double z, float yaw, float pitch, int teleportId, ProtocolRelativePositionType ... relative) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
        this.teleportId = teleportId;
        this.relative = relative;
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeFloat(this.yaw);
        buf.writeFloat(this.pitch);
        int flags = 0;
        for (ProtocolRelativePositionType element : this.relative) {
            flags |= 1 << element.ordinal();
        }
        buf.writeByte(flags);
        if (protocolVersion >= 107) {
            SynchronizePlayerPositionPacket.writeVarInt(this.teleportId, buf);
        }
        if (protocolVersion >= 755 && protocolVersion <= 761) {
            buf.writeBoolean(true);
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        throw new UnsupportedOperationException();
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public int getTeleportId() {
        return this.teleportId;
    }

    public ProtocolRelativePositionType[] getRelative() {
        return this.relative;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public void setYaw(float yaw) {
        this.yaw = yaw;
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
    }

    public void setTeleportId(int teleportId) {
        this.teleportId = teleportId;
    }

    public void setRelative(ProtocolRelativePositionType[] relative) {
        this.relative = relative;
    }

    @Override
    public String toString() {
        return "SynchronizePlayerPositionPacket(x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ", yaw=" + this.getYaw() + ", pitch=" + this.getPitch() + ", teleportId=" + this.getTeleportId() + ", relative=" + Arrays.deepToString((Object[])this.getRelative()) + ")";
    }

    public SynchronizePlayerPositionPacket() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SynchronizePlayerPositionPacket)) {
            return false;
        }
        SynchronizePlayerPositionPacket other = (SynchronizePlayerPositionPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getX(), other.getX()) != 0) {
            return false;
        }
        if (Double.compare(this.getY(), other.getY()) != 0) {
            return false;
        }
        if (Double.compare(this.getZ(), other.getZ()) != 0) {
            return false;
        }
        if (Float.compare(this.getYaw(), other.getYaw()) != 0) {
            return false;
        }
        if (Float.compare(this.getPitch(), other.getPitch()) != 0) {
            return false;
        }
        if (this.getTeleportId() != other.getTeleportId()) {
            return false;
        }
        return Arrays.deepEquals((Object[])this.getRelative(), (Object[])other.getRelative());
    }

    protected boolean canEqual(Object other) {
        return other instanceof SynchronizePlayerPositionPacket;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $x = Double.doubleToLongBits(this.getX());
        result = result * 59 + (int)($x >>> 32 ^ $x);
        long $y = Double.doubleToLongBits(this.getY());
        result = result * 59 + (int)($y >>> 32 ^ $y);
        long $z = Double.doubleToLongBits(this.getZ());
        result = result * 59 + (int)($z >>> 32 ^ $z);
        result = result * 59 + Float.floatToIntBits(this.getYaw());
        result = result * 59 + Float.floatToIntBits(this.getPitch());
        result = result * 59 + this.getTeleportId();
        result = result * 59 + Arrays.deepHashCode((Object[])this.getRelative());
        return result;
    }
}

