/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.statistics;

import java.util.concurrent.atomic.LongAdder;
import net.shieldcommunity.nullcordx.api.NetworkStatistics;
import net.shieldcommunity.nullcordx.statistics.PerSecondStatistics;

public class NetworkStatisticsImpl
implements NetworkStatistics {
    private final PerSecondStatistics readBytesPerSecond = new PerSecondStatistics();
    private final PerSecondStatistics writeBytesPerSecond = new PerSecondStatistics();
    private final PerSecondStatistics readPacketPerSecond = new PerSecondStatistics();
    private final PerSecondStatistics writePacketPerSecond = new PerSecondStatistics();
    private final LongAdder totalReadBytes = new LongAdder();
    private final LongAdder totalWriteBytes = new LongAdder();
    private final LongAdder totalReadPackets = new LongAdder();
    private final LongAdder totalWritePackets = new LongAdder();

    public void addChannelReadPerSecond(long bytes) {
        this.readPacketPerSecond.increment();
        this.totalReadPackets.increment();
        this.readBytesPerSecond.increment(bytes);
        this.totalReadBytes.add(bytes);
    }

    public void addChannelWritePerSecond(long bytes) {
        this.writePacketPerSecond.increment();
        this.totalWritePackets.increment();
        this.writeBytesPerSecond.increment(bytes);
        this.totalWriteBytes.add(bytes);
    }

    public void handle() {
        this.readBytesPerSecond.handle();
        this.writeBytesPerSecond.handle();
        this.readPacketPerSecond.handle();
        this.writePacketPerSecond.handle();
    }

    public void reset() {
        this.readBytesPerSecond.reset();
        this.writeBytesPerSecond.reset();
        this.readPacketPerSecond.reset();
        this.writePacketPerSecond.reset();
        this.totalReadBytes.reset();
        this.totalWriteBytes.reset();
        this.totalReadPackets.reset();
        this.totalWritePackets.reset();
    }

    @Override
    public long getChannelReadBytesPerSecond() {
        return this.readBytesPerSecond.getValue();
    }

    @Override
    public long getChannelWriteBytesPerSecond() {
        return this.writeBytesPerSecond.getValue();
    }

    @Override
    public long getChannelReadPacketsPerSecond() {
        return this.readPacketPerSecond.getValue();
    }

    @Override
    public long getChannelWritePacketsPerSecond() {
        return this.writePacketPerSecond.getValue();
    }

    @Override
    public long getTotalChannelReadBytes() {
        return this.totalReadBytes.sum();
    }

    @Override
    public long getTotalChannelWriteBytes() {
        return this.totalWriteBytes.sum();
    }

    @Override
    public long getTotalChannelReadPackets() {
        return this.totalReadPackets.sum();
    }

    @Override
    public long getTotalChannelWritePackets() {
        return this.totalWritePackets.sum();
    }
}

