/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.statistics;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.shieldcommunity.nullcordx.ManagerComponent;
import net.shieldcommunity.nullcordx.NullCordXImpl;
import net.shieldcommunity.nullcordx.NullCordXLogger;
import net.shieldcommunity.nullcordx.libs.google.inject.Inject;
import net.shieldcommunity.nullcordx.libs.google.inject.Singleton;
import net.shieldcommunity.nullcordx.statistics.CachedNetworkStatistics;
import net.shieldcommunity.nullcordx.statistics.LiveStatsType;
import net.shieldcommunity.nullcordx.statistics.NetworkStatisticsImpl;
import net.shieldcommunity.nullcordx.statistics.PlayerLiveStatsData;
import net.shieldcommunity.nullcordx.statistics.StatisticsManagerImpl;
import net.shieldcommunity.nullcordx.tasks.SafeScheduledTask;

@Singleton
public class PlayerStatisticsUpdaterManager
extends ManagerComponent {
    private final StatisticsManagerImpl statisticsManager;
    private final ConcurrentMap<String, PlayerLiveStatsData> players = new ConcurrentHashMap<String, PlayerLiveStatsData>();
    private ScheduledExecutorService updateStatsTimer;
    private String cachedProcessCpuLoad = StatisticsManagerImpl.getProcessorUsage(false);
    private String cachedSystemCpuLoad = StatisticsManagerImpl.getProcessorUsage(true);
    private String cachedHeapMaxMemory = "";
    private String cachedHeapTotalMemory = "";
    private String cachedHeapFreeMemory = "";
    private String cachedHeapUsedMemory = "";
    private String cachedDirectUsedMemory = "";
    private CachedNetworkStatistics cachedUpstreamNetwork = new CachedNetworkStatistics(0L, 0L, 0L, 0L);
    private CachedNetworkStatistics cachedDownstreamNetwork = new CachedNetworkStatistics(0L, 0L, 0L, 0L);
    private long lastCacheUpdateTime = 0L;

    @Inject
    public PlayerStatisticsUpdaterManager(NullCordXLogger logger, NullCordXImpl nullCordX, StatisticsManagerImpl statisticsManager) {
        super(logger, nullCordX, "PlayerStatisticsUpdater");
        this.statisticsManager = statisticsManager;
    }

    @Override
    public void onLoad(ForkJoinPool executor) {
        this.updateStatsTimer = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("NullCordX-PlayerStatisticsUpdater-%d").build());
        this.updateStatsTimer.scheduleWithFixedDelay(new SafeScheduledTask(this.logger){

            @Override
            public void doTask() {
                if (PlayerStatisticsUpdaterManager.this.players.isEmpty()) {
                    return;
                }
                PlayerStatisticsUpdaterManager.this.updateCache();
                for (PlayerLiveStatsData player : PlayerStatisticsUpdaterManager.this.players.values()) {
                    LiveStatsType statsType = player.getType();
                    BaseComponent component = statsType.createStats(PlayerStatisticsUpdaterManager.this.nullCordX, PlayerStatisticsUpdaterManager.this, player);
                    player.sendMessage(component);
                    if (player.isConnected()) continue;
                    PlayerStatisticsUpdaterManager.this.removePlayer(player.getName());
                }
            }
        }, 100L, 100L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void onUnload() {
        try {
            this.updateStatsTimer.shutdown();
            this.updateStatsTimer.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.logger.log(Level.SEVERE, "Error during shutdown update stats timer", e);
        }
        this.updateStatsTimer = null;
    }

    private void updateCache() {
        if (System.currentTimeMillis() - this.lastCacheUpdateTime >= 250L) {
            this.lastCacheUpdateTime = System.currentTimeMillis();
            this.cachedProcessCpuLoad = StatisticsManagerImpl.getProcessorUsage(false);
            this.cachedSystemCpuLoad = StatisticsManagerImpl.getProcessorUsage(true);
            long maxHeapMem = Runtime.getRuntime().maxMemory() / 1024L / 1024L;
            long totalHeapMem = Runtime.getRuntime().totalMemory() / 1024L / 1024L;
            long freeHeapMem = Runtime.getRuntime().freeMemory() / 1024L / 1024L;
            long usedHeapMem = maxHeapMem - freeHeapMem;
            long usedDirectMem = 0L;
            List<BufferPoolMXBean> pools = ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class);
            for (BufferPoolMXBean pool : pools) {
                usedDirectMem += pool.getMemoryUsed();
            }
            usedDirectMem = usedDirectMem / 1024L / 1024L;
            this.cachedHeapMaxMemory = String.valueOf(maxHeapMem);
            this.cachedHeapTotalMemory = String.valueOf(totalHeapMem);
            this.cachedHeapFreeMemory = String.valueOf(freeHeapMem);
            this.cachedHeapUsedMemory = String.valueOf(usedHeapMem);
            this.cachedDirectUsedMemory = String.valueOf(usedDirectMem);
            this.cachedUpstreamNetwork = PlayerStatisticsUpdaterManager.createCachedNetworkStatistics(this.statisticsManager.getUpstreamNetworkStatistics());
            this.cachedDownstreamNetwork = PlayerStatisticsUpdaterManager.createCachedNetworkStatistics(this.statisticsManager.getDownstreamNetworkStatistics());
        }
    }

    public PlayerLiveStatsData addPlayer(ProxiedPlayer player) {
        String name = player.getName().toLowerCase();
        PlayerLiveStatsData value = new PlayerLiveStatsData(name, player);
        this.players.put(name, value);
        return value;
    }

    public PlayerLiveStatsData getPlayer(String player) {
        return (PlayerLiveStatsData)this.players.get(player.toLowerCase());
    }

    public PlayerLiveStatsData removePlayer(String player) {
        return (PlayerLiveStatsData)this.players.remove(player.toLowerCase());
    }

    private static CachedNetworkStatistics createCachedNetworkStatistics(NetworkStatisticsImpl networkStatistics) {
        long readPackets = networkStatistics.getChannelReadPacketsPerSecond();
        long readBytes = networkStatistics.getChannelReadBytesPerSecond();
        long writePackets = networkStatistics.getChannelWritePacketsPerSecond();
        long writeBytes = networkStatistics.getChannelWriteBytesPerSecond();
        return new CachedNetworkStatistics(readBytes, writeBytes, readPackets, writePackets);
    }

    public StatisticsManagerImpl getStatisticsManager() {
        return this.statisticsManager;
    }

    public String getCachedProcessCpuLoad() {
        return this.cachedProcessCpuLoad;
    }

    public String getCachedSystemCpuLoad() {
        return this.cachedSystemCpuLoad;
    }

    public String getCachedHeapMaxMemory() {
        return this.cachedHeapMaxMemory;
    }

    public String getCachedHeapTotalMemory() {
        return this.cachedHeapTotalMemory;
    }

    public String getCachedHeapFreeMemory() {
        return this.cachedHeapFreeMemory;
    }

    public String getCachedHeapUsedMemory() {
        return this.cachedHeapUsedMemory;
    }

    public String getCachedDirectUsedMemory() {
        return this.cachedDirectUsedMemory;
    }

    public CachedNetworkStatistics getCachedUpstreamNetwork() {
        return this.cachedUpstreamNetwork;
    }

    public CachedNetworkStatistics getCachedDownstreamNetwork() {
        return this.cachedDownstreamNetwork;
    }
}

