/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.statistics;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.text.DecimalFormat;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.logging.Level;
import net.shieldcommunity.nullcordx.ManagerComponent;
import net.shieldcommunity.nullcordx.NullCordXImpl;
import net.shieldcommunity.nullcordx.NullCordXLogger;
import net.shieldcommunity.nullcordx.api.StatisticsManager;
import net.shieldcommunity.nullcordx.api.events.BotAttackDetectedEvent;
import net.shieldcommunity.nullcordx.api.events.BotAttackEndedEvent;
import net.shieldcommunity.nullcordx.api.events.PingAttackDetectedEvent;
import net.shieldcommunity.nullcordx.api.events.PingAttackEndedEvent;
import net.shieldcommunity.nullcordx.api.events.SpamAttackDetectedEvent;
import net.shieldcommunity.nullcordx.api.events.SpamAttackEndedEvent;
import net.shieldcommunity.nullcordx.config.AntibotSettings;
import net.shieldcommunity.nullcordx.config.ConfigSettings;
import net.shieldcommunity.nullcordx.config.MotdSettings;
import net.shieldcommunity.nullcordx.libs.google.inject.Inject;
import net.shieldcommunity.nullcordx.libs.google.inject.Singleton;
import net.shieldcommunity.nullcordx.netty.ChannelStatisticsAndPacketLimiterUpstreamHandler;
import net.shieldcommunity.nullcordx.netty.ChannelStatisticsDownstreamHandler;
import net.shieldcommunity.nullcordx.statistics.CountedAttackStatistics;
import net.shieldcommunity.nullcordx.statistics.NetworkStatisticsImpl;
import net.shieldcommunity.nullcordx.statistics.PerSecondStatistics;
import net.shieldcommunity.nullcordx.tasks.SafeScheduledTask;

@Singleton
public class StatisticsManagerImpl
extends ManagerComponent
implements StatisticsManager {
    private final PerSecondStatistics connectionsPerSecond = new PerSecondStatistics();
    private final PerSecondStatistics pingsPerSecond = new PerSecondStatistics();
    private final PerSecondStatistics blockedConnectionsPerSecond = new PerSecondStatistics();
    private final LongAdder totalConnections = new LongAdder();
    private final LongAdder totalBlocked = new LongAdder();
    private final NetworkStatisticsImpl upstreamNetworkStatistics = new NetworkStatisticsImpl();
    private final NetworkStatisticsImpl downstreamNetworkStatistics = new NetworkStatisticsImpl();
    private final CountedAttackStatistics botStatistics = new CountedAttackStatistics(this.nullCordX, "Bot", () -> new BotAttackDetectedEvent(System.currentTimeMillis()), () -> new BotAttackEndedEvent(System.currentTimeMillis()));
    private final CountedAttackStatistics pingStatistics = new CountedAttackStatistics(this.nullCordX, "Ping", () -> new PingAttackDetectedEvent(System.currentTimeMillis()), () -> new PingAttackEndedEvent(System.currentTimeMillis()));
    private final CountedAttackStatistics spamStatistics = new CountedAttackStatistics(this.nullCordX, "Spam", () -> new SpamAttackDetectedEvent(System.currentTimeMillis()), () -> new SpamAttackEndedEvent(System.currentTimeMillis()), () -> {
        if (ConfigSettings.IMP.LOGS.ALWAYS_ENABLED_UNTIL_SPAM_ATTACK) {
            this.logger.log(Level.WARNING, "Disabling all debug logs...");
            ConfigSettings.IMP.LOGS.PRINT_FULL_STACKTRACES = false;
            ConfigSettings.IMP.LOGS.PRINT_HANDLER_BOSS_EXCEPTIONS = false;
            ConfigSettings.IMP.LOGS.PRINT_NULLCORDX_DEBUG = false;
            ConfigSettings.IMP.LOGS.PRINT_PING_HANDLER_EXCEPTIONS = false;
            ConfigSettings.IMP.LOGS.PRINT_SERVER_CONNECTING_EXCEPTIONS = false;
        }
    }, () -> {
        if (ConfigSettings.IMP.LOGS.ALWAYS_ENABLED_UNTIL_SPAM_ATTACK) {
            this.logger.log(Level.WARNING, "Enabling all debug logs...");
            ConfigSettings.IMP.LOGS.PRINT_FULL_STACKTRACES = true;
            ConfigSettings.IMP.LOGS.PRINT_HANDLER_BOSS_EXCEPTIONS = true;
            ConfigSettings.IMP.LOGS.PRINT_NULLCORDX_DEBUG = true;
            ConfigSettings.IMP.LOGS.PRINT_PING_HANDLER_EXCEPTIONS = true;
            ConfigSettings.IMP.LOGS.PRINT_SERVER_CONNECTING_EXCEPTIONS = true;
        }
    });
    private ScheduledExecutorService updateStatsTimer;

    @Inject
    public StatisticsManagerImpl(NullCordXLogger logger, NullCordXImpl nullCordX) {
        super(logger, nullCordX, "StatisticsManager");
    }

    @Override
    protected void onLoad(ForkJoinPool executor) {
        this.botStatistics.load(AntibotSettings.IMP.ANTIBOT.BOT_ATTACK_DETECTION.BOT_THRESHOLD, AntibotSettings.IMP.ANTIBOT.BOT_ATTACK_DETECTION.BOT_PROTECTION_TIME, AntibotSettings.IMP.ANTIBOT.BOT_ATTACK_DETECTION.BOT_THRESHOLD_TIME);
        this.pingStatistics.load(MotdSettings.IMP.MOTD.PING_ATTACK_DETECTION.PING_THRESHOLD, MotdSettings.IMP.MOTD.PING_ATTACK_DETECTION.PING_PROTECTION_TIME, MotdSettings.IMP.MOTD.PING_ATTACK_DETECTION.PING_THRESHOLD_TIME);
        this.spamStatistics.load(ConfigSettings.IMP.PROTECTION.SPAM_ATTACK_DETECTION.SPAM_THRESHOLD, ConfigSettings.IMP.PROTECTION.SPAM_ATTACK_DETECTION.SPAM_PROTECTION_TIME, ConfigSettings.IMP.PROTECTION.SPAM_ATTACK_DETECTION.SPAM_THRESHOLD_TIME);
        if (ConfigSettings.IMP.LOGS.ALWAYS_ENABLED_UNTIL_SPAM_ATTACK) {
            this.logger.log(Level.WARNING, "Enabling all debug logs on startup...");
            ConfigSettings.IMP.LOGS.PRINT_FULL_STACKTRACES = true;
            ConfigSettings.IMP.LOGS.PRINT_HANDLER_BOSS_EXCEPTIONS = true;
            ConfigSettings.IMP.LOGS.PRINT_NULLCORDX_DEBUG = true;
            ConfigSettings.IMP.LOGS.PRINT_PING_HANDLER_EXCEPTIONS = true;
            ConfigSettings.IMP.LOGS.PRINT_SERVER_CONNECTING_EXCEPTIONS = true;
        }
        this.loadUpdateTimer();
    }

    @Override
    protected void onUnload() {
        this.unloadUpdateTimer();
    }

    public void addBlockedConnectionPerSecond() {
        this.blockedConnectionsPerSecond.increment();
        this.totalBlocked.increment();
    }

    public void addConnectionPerSecond() {
        this.connectionsPerSecond.increment();
        this.totalConnections.increment();
    }

    public void addPingPerSecond() {
        this.pingsPerSecond.increment();
    }

    @Override
    public long getBotCounter() {
        return this.botStatistics.getCounter();
    }

    @Override
    public long getBotCounterEver() {
        return this.botStatistics.getMaxValueEver();
    }

    @Override
    public long getPingCounter() {
        return this.pingStatistics.getCounter();
    }

    @Override
    public long getPingCounterEver() {
        return this.pingStatistics.getMaxValueEver();
    }

    @Override
    public long getSpamCounter() {
        return this.spamStatistics.getCounter();
    }

    @Override
    public long getSpamCounterEver() {
        return this.spamStatistics.getMaxValueEver();
    }

    @Override
    public long getConnectionsPerSecond() {
        return this.connectionsPerSecond.getValue();
    }

    @Override
    public long getConnectionsPerSecondEver() {
        return this.connectionsPerSecond.getMaxValue();
    }

    @Override
    public long getPingsPerSecond() {
        return this.pingsPerSecond.getValue();
    }

    @Override
    public long getPingsPerSecondEver() {
        return this.pingsPerSecond.getMaxValue();
    }

    @Override
    public long getBlockedConnectionsPerSecond() {
        return this.blockedConnectionsPerSecond.getValue();
    }

    @Override
    public long getBlockedConnectionsPerSecondEver() {
        return this.blockedConnectionsPerSecond.getMaxValue();
    }

    @Override
    public long getTotalConnections() {
        return this.totalConnections.sum();
    }

    @Override
    public long getTotalBlocked() {
        return this.totalBlocked.sum();
    }

    @Override
    public long getOpenedUpstreamConnections() {
        return ChannelStatisticsAndPacketLimiterUpstreamHandler.OPENED_CONNECTIONS.sum();
    }

    @Override
    public long getOpenedDownstreamConnections() {
        return ChannelStatisticsDownstreamHandler.OPENED_CONNECTIONS.sum();
    }

    public void reset() {
        this.connectionsPerSecond.reset();
        this.pingsPerSecond.reset();
        this.blockedConnectionsPerSecond.reset();
        this.totalConnections.reset();
        this.totalBlocked.reset();
        this.upstreamNetworkStatistics.reset();
        this.downstreamNetworkStatistics.reset();
        this.botStatistics.reset();
        this.pingStatistics.reset();
        this.spamStatistics.reset();
    }

    private void loadUpdateTimer() {
        if (this.updateStatsTimer != null) {
            return;
        }
        this.updateStatsTimer = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("NullCordX-StatisticsUpdater-%d").build());
        this.updateStatsTimer.scheduleWithFixedDelay(new SafeScheduledTask(this.logger){

            @Override
            public void doTask() {
                StatisticsManagerImpl.this.connectionsPerSecond.handle();
                StatisticsManagerImpl.this.pingsPerSecond.handle();
                StatisticsManagerImpl.this.blockedConnectionsPerSecond.handle();
                StatisticsManagerImpl.this.upstreamNetworkStatistics.handle();
                StatisticsManagerImpl.this.downstreamNetworkStatistics.handle();
                StatisticsManagerImpl.this.botStatistics.handleProtectionCheck();
                StatisticsManagerImpl.this.botStatistics.handleCounter();
                StatisticsManagerImpl.this.botStatistics.handleEvent();
                StatisticsManagerImpl.this.pingStatistics.handleProtectionCheck();
                StatisticsManagerImpl.this.pingStatistics.handleCounter();
                StatisticsManagerImpl.this.pingStatistics.handleEvent();
                StatisticsManagerImpl.this.spamStatistics.handleProtectionCheck();
                StatisticsManagerImpl.this.spamStatistics.handleCounter();
                StatisticsManagerImpl.this.spamStatistics.handleEvent();
            }
        }, 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    private void unloadUpdateTimer() {
        if (this.updateStatsTimer == null) {
            return;
        }
        try {
            this.updateStatsTimer.shutdown();
            this.updateStatsTimer.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.logger.log(Level.SEVERE, "Error during shutdown update stats timer", e);
        }
        this.updateStatsTimer = null;
    }

    public static String getProcessorUsage(boolean system) {
        double cpuUsage;
        try {
            OperatingSystemMXBean systemBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            cpuUsage = (system ? systemBean.getCpuLoad() : systemBean.getProcessCpuLoad()) * 100.0;
        }
        catch (Throwable t2) {
            return "Not available: " + t2.getMessage();
        }
        String usage = cpuUsage < 0.0 ? "Not available" : StatisticsManagerImpl.getCpuFormat(cpuUsage, new DecimalFormat("#.#"));
        return usage;
    }

    public static String getCpuFormat(double cpu, DecimalFormat df) {
        if (cpu <= 15.0) {
            return "\u00a77" + df.format(cpu) + "%";
        }
        if (cpu <= 45.0) {
            return "\u00a7f" + df.format(cpu) + "%";
        }
        if (cpu <= 75.0) {
            return "\u00a7c" + df.format(cpu) + "%";
        }
        if (cpu <= 100.0) {
            return "\u00a74" + df.format(cpu) + "%";
        }
        return "\u00a77" + df.format(cpu) + "%";
    }

    public static String bytesIntoHumanReadable(long bytes) {
        return StatisticsManagerImpl.bytesIntoHumanReadable(bytes, false);
    }

    public static String bytesIntoHumanReadable(long bytes, boolean ki) {
        if (ki) {
            bytes *= 8L;
        }
        double kilobyte = 1024.0;
        double megabyte = kilobyte * 1024.0;
        double gigabyte = megabyte * 1024.0;
        double terabyte = gigabyte * 1024.0;
        DecimalFormat df = new DecimalFormat("#.##");
        if (bytes >= 0L && (double)bytes < kilobyte) {
            return bytes + (ki ? " Bi" : " B");
        }
        if ((double)bytes >= kilobyte && (double)bytes < megabyte) {
            return df.format((double)bytes / kilobyte) + (ki ? " KiB" : " KB");
        }
        if ((double)bytes >= megabyte && (double)bytes < gigabyte) {
            return df.format((double)bytes / megabyte) + (ki ? " MiB" : " MB");
        }
        if ((double)bytes >= gigabyte && (double)bytes < terabyte) {
            return df.format((double)bytes / gigabyte) + (ki ? " GiB" : " GB");
        }
        if ((double)bytes >= terabyte) {
            return df.format((double)bytes / terabyte) + (ki ? " TiB" : " TB");
        }
        return bytes + " Bites";
    }

    @Override
    public NetworkStatisticsImpl getUpstreamNetworkStatistics() {
        return this.upstreamNetworkStatistics;
    }

    @Override
    public NetworkStatisticsImpl getDownstreamNetworkStatistics() {
        return this.downstreamNetworkStatistics;
    }

    public CountedAttackStatistics getBotStatistics() {
        return this.botStatistics;
    }

    public CountedAttackStatistics getPingStatistics() {
        return this.pingStatistics;
    }

    public CountedAttackStatistics getSpamStatistics() {
        return this.spamStatistics;
    }
}

