/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.statistics.type;

import java.text.NumberFormat;
import java.util.Locale;
import net.md_5.bungee.api.chat.TextComponent;
import net.shieldcommunity.nullcordx.NullCordXImpl;
import net.shieldcommunity.nullcordx.statistics.PlayerLiveStatsData;
import net.shieldcommunity.nullcordx.statistics.PlayerStatisticsUpdaterManager;
import net.shieldcommunity.nullcordx.statistics.StatisticsManagerImpl;
import net.shieldcommunity.nullcordx.statistics.type.StatsType;

public class NetworkStatsType
implements StatsType {
    @Override
    public TextComponent createStats(NullCordXImpl nullCordX, PlayerStatisticsUpdaterManager statisticsUpdater, PlayerLiveStatsData player) {
        NumberFormat nf = NumberFormat.getInstance(Locale.US);
        StatisticsManagerImpl statisticsManager = statisticsUpdater.getStatisticsManager();
        long readPackets = statisticsUpdater.getCachedUpstreamNetwork().getCachedReadPackets() + statisticsUpdater.getCachedDownstreamNetwork().getCachedReadPackets();
        String readPacketsString = nf.format(readPackets);
        long readBytes = statisticsUpdater.getCachedUpstreamNetwork().getCachedReadBytes() + statisticsUpdater.getCachedDownstreamNetwork().getCachedReadBytes();
        String readBytesString = StatisticsManagerImpl.bytesIntoHumanReadable(readBytes);
        long writePackets = statisticsUpdater.getCachedUpstreamNetwork().getCachedWritePackets() + statisticsUpdater.getCachedDownstreamNetwork().getCachedWritePackets();
        String writePacketsString = nf.format(writePackets);
        long writeBytes = statisticsUpdater.getCachedUpstreamNetwork().getCachedWriteBytes() + statisticsUpdater.getCachedDownstreamNetwork().getCachedWriteBytes();
        String writeBytesString = StatisticsManagerImpl.bytesIntoHumanReadable(writeBytes);
        long oc = statisticsManager.getOpenedUpstreamConnections() + statisticsManager.getOpenedDownstreamConnections();
        int ping = player.getPlayer().getPing();
        return new TextComponent("\u00a79\u00a7lNull\u00a7b\u00a7lCord\u00a7f\u00a7lX \u00a77\u00bb \u00a7fPINS: \u00a7b" + readPacketsString + " \u00a78- \u00a7fPOUTS: \u00a7b" + writePacketsString + " \u00a78- \u00a7fBINS: \u00a7b" + readBytesString + " \u00a78- \u00a7fBOUTS: \u00a7b" + writeBytesString + " \u00a78- \u00a7fCPS: \u00a7b" + nf.format(statisticsManager.getConnectionsPerSecond()) + " \u00a78- \u00a7fOC: \u00a7b" + nf.format(oc) + " \u00a78- \u00a7fPING: \u00a7b" + ping + "\u00a7fms");
    }
}

