/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.utils;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.Util;
import net.md_5.bungee.api.config.ServerInfo;
import net.shieldcommunity.nullcordx.ManagerComponent;
import net.shieldcommunity.nullcordx.NullCordXImpl;
import net.shieldcommunity.nullcordx.NullCordXLogger;
import net.shieldcommunity.nullcordx.config.ConfigSettings;
import net.shieldcommunity.nullcordx.libs.google.inject.Inject;
import net.shieldcommunity.nullcordx.libs.google.inject.Singleton;
import net.shieldcommunity.nullcordx.tasks.SafeScheduledTask;

@Singleton
public class DynamicDNS
extends ManagerComponent {
    private ScheduledExecutorService timer = null;

    @Inject
    public DynamicDNS(NullCordXLogger logger, NullCordXImpl nullCordX) {
        super(logger, nullCordX, "DynamicDNS");
    }

    @Override
    protected void onLoad(ForkJoinPool executor) {
        if (!ConfigSettings.IMP.DYNAMIC_DNS.ENABLED) {
            this.logger.log(Level.INFO, this.componentName + " disabled by configuration!");
            return;
        }
        int time = ConfigSettings.IMP.DYNAMIC_DNS.CHECK_COOLDOWN;
        this.timer = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("NullCordX-DynamicDNS-%d").build());
        this.timer.scheduleWithFixedDelay(new SafeScheduledTask(this.logger){

            @Override
            public void doTask() {
                FindData data = DynamicDNS.findDifferendIp();
                if (data != null) {
                    DynamicDNS.this.logger.log(Level.WARNING, "It seems that '" + data.getCurrentIp() + "' of server '" + data.getServerName() + "' has been changed to '" + data.getNewIp() + "' (DNS changed?), updating server list...");
                    BungeeCord.getInstance().getConfig().updateServerIPs();
                }
            }
        }, time, time, TimeUnit.MILLISECONDS);
    }

    @Override
    protected void onUnload() {
        if (this.timer != null) {
            try {
                this.timer.shutdown();
                this.timer.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                this.logger.log(Level.SEVERE, "Failed to shutdown timer", e);
            }
        }
        this.timer = null;
    }

    private static FindData findDifferendIp() {
        for (ServerInfo info : BungeeCord.getInstance().getServersCopy().values()) {
            InetSocketAddress updatedIp;
            InetAddress updatedInetAddress;
            InetSocketAddress currentAddress = info.getAddress();
            InetAddress currentInetAddress = currentAddress.getAddress();
            if (currentInetAddress == null || (updatedInetAddress = (updatedIp = (InetSocketAddress)Util.getAddr(currentAddress.getHostName() + ":" + currentAddress.getPort())).getAddress()) == null) continue;
            String currentIp = currentInetAddress.getHostAddress();
            String newIp = updatedInetAddress.getHostAddress();
            if (newIp.equals(currentIp)) continue;
            return new FindData(info.getName(), currentIp, newIp);
        }
        return null;
    }

    private static final class FindData {
        private final String serverName;
        private final String currentIp;
        private final String newIp;

        public FindData(String serverName, String currentIp, String newIp) {
            this.serverName = serverName;
            this.currentIp = currentIp;
            this.newIp = newIp;
        }

        public String getServerName() {
            return this.serverName;
        }

        public String getCurrentIp() {
            return this.currentIp;
        }

        public String getNewIp() {
            return this.newIp;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FindData)) {
                return false;
            }
            FindData other = (FindData)o;
            String this$serverName = this.getServerName();
            String other$serverName = other.getServerName();
            if (this$serverName == null ? other$serverName != null : !this$serverName.equals(other$serverName)) {
                return false;
            }
            String this$currentIp = this.getCurrentIp();
            String other$currentIp = other.getCurrentIp();
            if (this$currentIp == null ? other$currentIp != null : !this$currentIp.equals(other$currentIp)) {
                return false;
            }
            String this$newIp = this.getNewIp();
            String other$newIp = other.getNewIp();
            return !(this$newIp == null ? other$newIp != null : !this$newIp.equals(other$newIp));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $serverName = this.getServerName();
            result = result * 59 + ($serverName == null ? 43 : $serverName.hashCode());
            String $currentIp = this.getCurrentIp();
            result = result * 59 + ($currentIp == null ? 43 : $currentIp.hashCode());
            String $newIp = this.getNewIp();
            result = result * 59 + ($newIp == null ? 43 : $newIp.hashCode());
            return result;
        }

        public String toString() {
            return "DynamicDNS.FindData(serverName=" + this.getServerName() + ", currentIp=" + this.getCurrentIp() + ", newIp=" + this.getNewIp() + ")";
        }
    }
}

