/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.utils;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.regex.Pattern;

public final class InetSocketUtil {
    public static final Pattern IP_V_4_PATTERN = Pattern.compile("^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$");
    public static final Pattern IP_V_6_PATTERN = Pattern.compile("(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))");

    public static InetAddress getAddress(SocketAddress socketAddress) {
        return ((InetSocketAddress)socketAddress).getAddress();
    }

    public static InetAddress getAddressSafe(String ip) {
        if (!InetSocketUtil.isIPv4(ip) && !InetSocketUtil.isIPv6(ip)) {
            return null;
        }
        try {
            return InetAddress.getByName(ip);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public static boolean isIPv4(String ip) {
        return IP_V_4_PATTERN.matcher(ip).matches();
    }

    public static boolean isIPv6(String ip) {
        return IP_V_6_PATTERN.matcher(ip).matches();
    }

    private InetSocketUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

