/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.launch;

import java.io.File;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import net.shieldcommunity.nullcordx.libs.google.inject.Binder;
import net.shieldcommunity.nullcordx.libs.google.inject.Guice;
import net.shieldcommunity.nullcordx.libs.google.inject.Key;
import net.shieldcommunity.nullcordx.libs.google.inject.Module;
import net.shieldcommunity.nullcordx.libs.google.inject.name.Names;
import net.shieldcommunity.nullcordx.libs.javax.inject.Inject;
import org.eclipse.sisu.inject.MutableBeanLocator;
import org.eclipse.sisu.space.BeanScanning;
import org.eclipse.sisu.space.ClassSpace;
import org.eclipse.sisu.space.SpaceModule;
import org.eclipse.sisu.space.URLClassSpace;
import org.eclipse.sisu.wire.ParameterKeys;
import org.eclipse.sisu.wire.WireModule;
import org.junit.After;
import org.junit.Before;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;

public abstract class InjectedTest
implements Module {
    private String basedir;
    @Inject
    private MutableBeanLocator locator;

    @Before
    @BeforeMethod
    public void setUp() throws Exception {
        Guice.createInjector(new WireModule(new SetUpModule(), this.spaceModule()));
    }

    @After
    @AfterMethod
    public void tearDown() throws Exception {
        this.locator.clear();
    }

    public SpaceModule spaceModule() {
        return new SpaceModule(this.space(), this.scanning());
    }

    public ClassSpace space() {
        return new URLClassSpace(this.getClass().getClassLoader());
    }

    public BeanScanning scanning() {
        return BeanScanning.CACHE;
    }

    @Override
    public void configure(Binder binder) {
    }

    public void configure(Properties properties) {
    }

    public final <T> T lookup(Class<T> type) {
        return this.lookup(Key.get(type));
    }

    public final <T> T lookup(Class<T> type, String name) {
        return this.lookup(type, Names.named(name));
    }

    public final <T> T lookup(Class<T> type, Class<? extends Annotation> qualifier) {
        return this.lookup(Key.get(type, qualifier));
    }

    public final <T> T lookup(Class<T> type, Annotation qualifier) {
        return this.lookup(Key.get(type, qualifier));
    }

    public final String getBasedir() {
        if (this.basedir == null) {
            this.basedir = System.getProperty("basedir", new File("").getAbsolutePath());
        }
        return this.basedir;
    }

    private <T> T lookup(Key<T> key) {
        Iterator i = this.locator.locate(key).iterator();
        return i.hasNext() ? (T)((Map.Entry)i.next()).getValue() : null;
    }

    final class SetUpModule
    implements Module {
        SetUpModule() {
        }

        @Override
        public void configure(Binder binder) {
            binder.install(InjectedTest.this);
            Properties properties = new Properties();
            properties.put("basedir", InjectedTest.this.getBasedir());
            InjectedTest.this.configure(properties);
            binder.bind(ParameterKeys.PROPERTIES).toInstance(properties);
            binder.requestInjection(InjectedTest.this);
        }
    }
}

