/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.util;

import chanceCubes.CCubesCore;
import chanceCubes.config.CCubesSettings;
import chanceCubes.rewards.rewardparts.CommandPart;
import chanceCubes.util.CCubesCommandSender;
import chanceCubes.util.CustomEntry;
import chanceCubes.util.FileUtil;
import com.google.gson.JsonObject;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketTitle;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Level;

public class RewardsUtil {
    private static List<String> oredicts = new ArrayList<String>();
    private static String[] possibleModOres = new String[]{"oreAluminum", "oreCopper", "oreMythril", "oreLead", "orePlutonium", "oreQuartz", "oreRuby", "oreSalt", "oreSapphire", "oreSilver", "oreTin", "oreUranium", "oreZinc"};
    private static List<String> fluids = new ArrayList<String>();
    public static final Random rand = new Random();

    public static List<String> getOreDicts() {
        return oredicts;
    }

    public static List<String> getFluids() {
        return fluids;
    }

    public static void initData() {
        oredicts.add("oreGold");
        oredicts.add("oreIron");
        oredicts.add("oreLapis");
        oredicts.add("oreDiamond");
        oredicts.add("oreRedstone");
        oredicts.add("oreEmerald");
        oredicts.add("oreQuartz");
        oredicts.add("oreCoal");
        for (String oreDict : possibleModOres) {
            if (!OreDictionary.doesOreNameExist((String)oreDict)) continue;
            oredicts.add(oreDict);
        }
        fluids.addAll(FluidRegistry.getRegisteredFluids().keySet());
    }

    public static CommandPart[] executeXCommands(String command, int amount) {
        CommandPart[] toReturn = new CommandPart[amount];
        for (int i = 0; i < amount; ++i) {
            toReturn[i] = new CommandPart(command);
        }
        return toReturn;
    }

    public static CommandPart[] executeXCommands(String command, int amount, int delay) {
        CommandPart[] toReturn = new CommandPart[amount];
        for (int i = 0; i < amount; ++i) {
            CommandPart part = new CommandPart(command);
            part.setDelay(delay);
            toReturn[i] = part;
        }
        return toReturn;
    }

    public static void sendMessageToNearPlayers(World world, BlockPos pos, int distance, String message) {
        for (int i = 0; i < world.field_73010_i.size(); ++i) {
            EntityPlayer entityplayer = (EntityPlayer)world.field_73010_i.get(i);
            double dist = Math.sqrt(Math.pow((double)pos.func_177958_n() - entityplayer.field_70165_t, 2.0) + Math.pow((double)pos.func_177956_o() - entityplayer.field_70163_u, 2.0) + Math.pow((double)pos.func_177952_p() - entityplayer.field_70161_v, 2.0));
            if (!(dist <= (double)distance)) continue;
            entityplayer.func_145747_a((ITextComponent)new TextComponentString(message));
        }
    }

    public static void sendMessageToAllPlayers(World world, String message) {
        for (int i = 0; i < world.field_73010_i.size(); ++i) {
            EntityPlayer entityplayer = (EntityPlayer)world.field_73010_i.get(i);
            entityplayer.func_145747_a((ITextComponent)new TextComponentString(message));
        }
    }

    public static ItemStack getItemStack(String mod, String itemName, int size) {
        return RewardsUtil.getItemStack(mod, itemName, size, 0);
    }

    public static ItemStack getItemStack(String mod, String itemName, int size, int meta) {
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(mod, itemName));
        return item == null ? ItemStack.field_190927_a : new ItemStack(item, size, meta);
    }

    public static Block getBlock(String mod, String blockName) {
        return (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(mod, blockName));
    }

    public static IBlockState getBlockStateFromBlockMeta(Block b, int meta) {
        return b.func_176203_a(meta);
    }

    public static boolean placeBlock(IBlockState b, World world, BlockPos pos) {
        return RewardsUtil.placeBlock(b, world, pos, 3, false);
    }

    public static boolean placeBlock(IBlockState b, World world, BlockPos pos, boolean ignoreUnbreakable) {
        return RewardsUtil.placeBlock(b, world, pos, 3, ignoreUnbreakable);
    }

    public static boolean placeBlock(IBlockState b, World world, BlockPos pos, int update, boolean ignoreUnbreakable) {
        if (!RewardsUtil.isBlockUnbreakable(world, pos) || ignoreUnbreakable) {
            world.func_180501_a(pos, b, update);
            return true;
        }
        return false;
    }

    public static boolean isBlockUnbreakable(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_185887_b(world, pos) == -1.0f || CCubesSettings.nonReplaceableBlocks.contains(world.func_180495_p(pos));
    }

    public static Enchantment getEnchantSafe(String res) {
        return RewardsUtil.getEnchantSafe(new ResourceLocation(res));
    }

    public static Enchantment getEnchantSafe(ResourceLocation res) {
        Enchantment ench = (Enchantment)Enchantment.field_185264_b.func_82594_a((Object)res);
        if (ench == null) {
            return Enchantments.field_185299_g;
        }
        return ench;
    }

    public static ItemStack getSpawnEggForEntity(ResourceLocation entityId) {
        ItemStack stack = new ItemStack(Items.field_151063_bx);
        NBTTagCompound nbttagcompound = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        NBTTagCompound nbttagcompound1 = new NBTTagCompound();
        nbttagcompound1.func_74778_a("id", entityId.toString());
        nbttagcompound.func_74782_a("EntityTag", (NBTBase)nbttagcompound1);
        stack.func_77982_d(nbttagcompound);
        return stack;
    }

    public static Block getRandomBlock() {
        return (Block)Block.field_149771_c.func_148754_a(rand.nextInt(Block.field_149771_c.func_148742_b().size()));
    }

    public static CustomEntry<Block, Integer> getRandomOre() {
        return RewardsUtil.getRandomOre(new ArrayList<String>());
    }

    public static CustomEntry<Block, Integer> getRandomOre(List<String> blacklist) {
        return RewardsUtil.getRandomOreFromOreDict(RewardsUtil.getRandomOreDict(blacklist));
    }

    public static CustomEntry<Block, Integer> getRandomOreFromOreDict(String oreDict) {
        NonNullList ores = OreDictionary.getOres((String)oreDict);
        Block ore = null;
        int meta = 0;
        int iteration = 0;
        while (ore == null) {
            if (++iteration > 100 || ores.size() == 0) {
                ore = Blocks.field_150365_q;
                continue;
            }
            ItemStack stack = (ItemStack)ores.get(rand.nextInt(ores.size()));
            ore = Block.func_149634_a((Item)stack.func_77973_b());
            meta = stack.func_77952_i();
        }
        return new CustomEntry<Block, Integer>(ore, meta);
    }

    public static Item getRandomItem() {
        Item item;
        while ((item = (Item)Item.field_150901_e.func_148754_a(rand.nextInt(Item.field_150901_e.func_148742_b().size()))) == null || item.func_77640_w() == null) {
        }
        return item;
    }

    public static ItemStack getRandomFirework() {
        ItemStack stack = new ItemStack(Items.field_151152_bP);
        NBTTagCompound data = new NBTTagCompound();
        data.func_74768_a("Flight", rand.nextInt(3) + 1);
        NBTTagList explosionList = new NBTTagList();
        for (int i = 0; i <= rand.nextInt(2); ++i) {
            NBTTagCompound explosionData = new NBTTagCompound();
            explosionData.func_74768_a("Type", rand.nextInt(5));
            explosionData.func_74757_a("Flicker", rand.nextBoolean());
            explosionData.func_74757_a("Trail", rand.nextBoolean());
            int[] colors = new int[rand.nextInt(2) + 1];
            for (int j = 0; j < colors.length; ++j) {
                colors[j] = RewardsUtil.getRandomColor();
            }
            explosionData.func_74783_a("Colors", colors);
            int[] fadeColors = new int[rand.nextInt(2) + 1];
            for (int j = 0; j < fadeColors.length; ++j) {
                fadeColors[j] = RewardsUtil.getRandomColor();
            }
            explosionData.func_74783_a("FadeColors", fadeColors);
            explosionList.func_74742_a((NBTBase)explosionData);
        }
        data.func_74782_a("Explosions", (NBTBase)explosionList);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("Fireworks", (NBTBase)data);
        stack.func_77982_d(nbt);
        return stack;
    }

    public static String getRandomOreDict() {
        return RewardsUtil.getRandomOreDict(new ArrayList<String>());
    }

    public static String getRandomOreDict(List<String> blacklist) {
        List oredicts = RewardsUtil.getOreDicts().stream().filter(line -> !blacklist.contains(line)).collect(Collectors.toList());
        return oredicts.size() > 0 ? (String)oredicts.get(rand.nextInt(oredicts.size())) : "oreCoal";
    }

    public static Fluid getRandomFluid() {
        Fluid f = FluidRegistry.getFluid((String)RewardsUtil.getFluids().get(rand.nextInt(RewardsUtil.getFluids().size())));
        while (f == null || f.getBlock() == null) {
            f = FluidRegistry.getFluid((String)RewardsUtil.getFluids().get(rand.nextInt(RewardsUtil.getFluids().size())));
        }
        return f;
    }

    public static PotionEffect getRandomPotionEffect() {
        Potion potion;
        int tries = 0;
        do {
            if (tries > 10) {
                return new PotionEffect(MobEffects.field_82731_v, 5, 1);
            }
            potion = (Potion)Potion.field_188414_b.func_148754_a(rand.nextInt(Potion.field_188414_b.func_148742_b().size()));
            ++tries;
        } while (potion == null);
        int duration = ((int)Math.round(Math.abs(rand.nextGaussian()) * 5.0) + 3) * 20;
        int amplifier = (int)Math.round(Math.abs(rand.nextGaussian() * 1.5));
        return new PotionEffect(potion, duration, amplifier);
    }

    public static Enchantment getRandomEnchantment() {
        Enchantment ench = Enchantment.func_185262_c((int)rand.nextInt(Enchantment.field_185264_b.func_148742_b().size()));
        while (ench == null) {
            ench = Enchantment.func_185262_c((int)rand.nextInt(Enchantment.field_185264_b.func_148742_b().size()));
        }
        return ench;
    }

    public static CustomEntry<Enchantment, Integer> getRandomEnchantmentAndLevel() {
        Enchantment ench = Enchantment.func_185262_c((int)rand.nextInt(Enchantment.field_185264_b.func_148742_b().size()));
        while (ench == null) {
            ench = Enchantment.func_185262_c((int)rand.nextInt(Enchantment.field_185264_b.func_148742_b().size()));
        }
        int level = rand.nextInt(ench.func_77325_b()) + ench.func_77319_d();
        return new CustomEntry<Enchantment, Integer>(ench, level);
    }

    public static int getRandomColor() {
        return new Color(rand.nextInt(256), rand.nextInt(256), rand.nextInt(256)).getRGB();
    }

    public static boolean isPlayerOnline(EntityPlayer player) {
        if (player == null) {
            return false;
        }
        for (EntityPlayerMP playerMP : player.field_70170_p.func_73046_m().func_184103_al().func_181057_v()) {
            if (!playerMP.func_110124_au().equals(player.func_110124_au())) continue;
            return true;
        }
        return false;
    }

    public static void executeCommand(World world, EntityPlayer player, String command) {
        RewardsUtil.executeCommand(world, player, player.func_180425_c(), command);
    }

    public static void executeCommand(World world, EntityPlayer player, BlockPos pos, String command) {
        MinecraftServer server = world.func_73046_m();
        if (server != null) {
            boolean rule = server.field_71305_c[0].func_82736_K().func_82766_b("commandBlockOutput");
            server.field_71305_c[0].func_82736_K().func_82764_b("commandBlockOutput", "false");
            server.func_71187_D().func_71556_a((ICommandSender)new CCubesCommandSender(player, pos), command);
            server.field_71305_c[0].func_82736_K().func_82764_b("commandBlockOutput", String.valueOf(rule));
        }
    }

    public static void setNearPlayersTitle(World world, BlockPos pos, int range, SPacketTitle.Type location, ITextComponent message, int fadeInTime, int displayTime, int fadeOutTime) {
        for (int i = 0; i < world.field_73010_i.size(); ++i) {
            EntityPlayer entityplayer = (EntityPlayer)world.field_73010_i.get(i);
            double dist = Math.sqrt(Math.pow((double)pos.func_177958_n() - entityplayer.field_70165_t, 2.0) + Math.pow((double)pos.func_177956_o() - entityplayer.field_70163_u, 2.0) + Math.pow((double)pos.func_177952_p() - entityplayer.field_70161_v, 2.0));
            if (!(dist <= (double)range)) continue;
            RewardsUtil.setPlayerTitle(entityplayer, location, message, fadeInTime, displayTime, fadeOutTime);
        }
    }

    public static void setAllPlayersTitle(World world, SPacketTitle.Type location, ITextComponent message, int fadeInTime, int displayTime, int fadeOutTime) {
        for (int i = 0; i < world.field_73010_i.size(); ++i) {
            RewardsUtil.setPlayerTitle((EntityPlayer)world.field_73010_i.get(i), location, message, fadeInTime, displayTime, fadeOutTime);
        }
    }

    public static void setPlayerTitle(EntityPlayer player, SPacketTitle.Type location, ITextComponent message, int fadeInTime, int displayTime, int fadeOutTime) {
        if (player instanceof EntityPlayerMP) {
            SPacketTitle titlePacket = new SPacketTitle(location, message, fadeInTime, displayTime, fadeOutTime);
            SPacketTitle timesPacket = new SPacketTitle(SPacketTitle.Type.TIMES, (ITextComponent)new TextComponentString(""), fadeInTime, displayTime, fadeOutTime);
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)timesPacket);
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)titlePacket);
        }
    }

    public static void setPlayerTitleReset(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            SPacketTitle resetPacket = new SPacketTitle(SPacketTitle.Type.RESET, (ITextComponent)new TextComponentString(""), 0, 0, 0);
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)resetPacket);
            resetPacket = new SPacketTitle(SPacketTitle.Type.CLEAR, (ITextComponent)new TextComponentString(""), 0, 0, 0);
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)resetPacket);
        }
    }

    public static String[] getHardcodedRewards() {
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(RewardsUtil.class.getResourceAsStream("/assets/chancecubes/rewards/rewards.txt")));
            ArrayList<String> files = new ArrayList<String>();
            while ((line = in.readLine()) != null) {
                files.add(line);
            }
            in.close();
            return files.toArray(new String[0]);
        }
        catch (Exception e) {
            CCubesCore.logger.log(Level.ERROR, "CHANCE CUBES WAS UNABLE TO LOAD IN ITS DEFAULT REWARDS!!!!");
            CCubesCore.logger.log(Level.ERROR, "REPORT TO MOD AUTHOR ASAP!!!");
            e.printStackTrace();
            return new String[0];
        }
    }

    public static JsonObject getRewardJson(String file) {
        BufferedReader in = new BufferedReader(new InputStreamReader(RewardsUtil.class.getResourceAsStream("/assets/chancecubes/rewards/" + file)));
        StringBuilder builder = new StringBuilder();
        try {
            String line;
            while ((line = in.readLine()) != null) {
                builder.append(line);
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return FileUtil.JSON_PARSER.parse(builder.toString()).getAsJsonObject();
    }
}

