/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.drop.value;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.Random;
import mod.lucky.drop.func.DropProcessData;
import mod.lucky.drop.value.DropStringUtils;
import mod.lucky.drop.value.HashVariables;
import mod.lucky.drop.value.ValueParser;
import mod.lucky.util.LuckyFunction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraftforge.common.ForgeHooks;

public class CustomNBTTags {
    public static final NBTTagCompound protection = CustomNBTTags.getEnchantment(0, 4);
    public static final NBTTagCompound fireProtection = CustomNBTTags.getEnchantment(1, 4);
    public static final NBTTagCompound featherFalling = CustomNBTTags.getEnchantment(2, 4);
    public static final NBTTagCompound blastProtection = CustomNBTTags.getEnchantment(3, 4);
    public static final NBTTagCompound projectileProtection = CustomNBTTags.getEnchantment(4, 4);
    public static final NBTTagCompound respiration = CustomNBTTags.getEnchantment(5, 3);
    public static final NBTTagCompound aquaAffinity = CustomNBTTags.getEnchantment(6, 1);
    public static final NBTTagCompound thorns = CustomNBTTags.getEnchantment(7, 3);
    public static final NBTTagCompound sharpness = CustomNBTTags.getEnchantment(16, 5);
    public static final NBTTagCompound smite = CustomNBTTags.getEnchantment(17, 5);
    public static final NBTTagCompound baneOfArthroponds = CustomNBTTags.getEnchantment(18, 5);
    public static final NBTTagCompound knockBack = CustomNBTTags.getEnchantment(19, 2);
    public static final NBTTagCompound fireAspect = CustomNBTTags.getEnchantment(20, 2);
    public static final NBTTagCompound looting = CustomNBTTags.getEnchantment(21, 3);
    public static final NBTTagCompound efficiency = CustomNBTTags.getEnchantment(32, 5);
    public static final NBTTagCompound silkTouch = CustomNBTTags.getEnchantment(33, 1);
    public static final NBTTagCompound unbreaking = CustomNBTTags.getEnchantment(34, 3);
    public static final NBTTagCompound fortune = CustomNBTTags.getEnchantment(35, 3);
    public static final NBTTagCompound power = CustomNBTTags.getEnchantment(48, 5);
    public static final NBTTagCompound punch = CustomNBTTags.getEnchantment(49, 2);
    public static final NBTTagCompound flame = CustomNBTTags.getEnchantment(50, 1);
    public static final NBTTagCompound infinity = CustomNBTTags.getEnchantment(51, 1);
    public static final NBTTagCompound luckOfTheSea = CustomNBTTags.getEnchantment(61, 3);
    public static final NBTTagCompound lure = CustomNBTTags.getEnchantment(62, 3);
    public static final NBTTagCompound speed = CustomNBTTags.getPotionEffect(1, 3, 9600);
    public static final NBTTagCompound slowness = CustomNBTTags.getPotionEffect(2, 3, 9600);
    public static final NBTTagCompound haste = CustomNBTTags.getPotionEffect(3, 3, 9600);
    public static final NBTTagCompound miningFatigue = CustomNBTTags.getPotionEffect(4, 3, 9600);
    public static final NBTTagCompound strength = CustomNBTTags.getPotionEffect(5, 3, 9600);
    public static final NBTTagCompound instantHealth = CustomNBTTags.getPotionEffect(6, 3, 0);
    public static final NBTTagCompound instantDamage = CustomNBTTags.getPotionEffect(7, 3, 0);
    public static final NBTTagCompound jumpBoost = CustomNBTTags.getPotionEffect(8, 3, 9600);
    public static final NBTTagCompound nausea = CustomNBTTags.getPotionEffect(9, 0, 9600);
    public static final NBTTagCompound regeneration = CustomNBTTags.getPotionEffect(10, 3, 9600);
    public static final NBTTagCompound resistance = CustomNBTTags.getPotionEffect(11, 3, 9600);
    public static final NBTTagCompound fireResistance = CustomNBTTags.getPotionEffect(12, 0, 9600);
    public static final NBTTagCompound waterBreathing = CustomNBTTags.getPotionEffect(13, 0, 9600);
    public static final NBTTagCompound invisibility = CustomNBTTags.getPotionEffect(14, 0, 9600);
    public static final NBTTagCompound blindness = CustomNBTTags.getPotionEffect(15, 0, 9600);
    public static final NBTTagCompound nightVision = CustomNBTTags.getPotionEffect(16, 0, 9600);
    public static final NBTTagCompound hunger = CustomNBTTags.getPotionEffect(17, 3, 9600);
    public static final NBTTagCompound weakness = CustomNBTTags.getPotionEffect(18, 3, 9600);
    public static final NBTTagCompound poison = CustomNBTTags.getPotionEffect(19, 3, 9600);
    public static final NBTTagCompound wither = CustomNBTTags.getPotionEffect(20, 3, 9600);
    public static final NBTTagCompound healthBoost = CustomNBTTags.getPotionEffect(21, 3, 9600);
    public static final NBTTagCompound absorbtion = CustomNBTTags.getPotionEffect(22, 3, 9600);
    public static final NBTTagCompound saturation = CustomNBTTags.getPotionEffect(23, 3, 9600);
    private static final Gson GSON_INSTANCE = new GsonBuilder().registerTypeAdapter(RandomValueRange.class, (Object)new RandomValueRange.Serializer()).registerTypeAdapter(LootPool.class, (Object)new LootPool.Serializer()).registerTypeAdapter(LootTable.class, (Object)new LootTable.Serializer()).registerTypeHierarchyAdapter(LootEntry.class, (Object)new LootEntry.Serializer()).registerTypeHierarchyAdapter(LootFunction.class, (Object)new LootFunctionManager.Serializer()).registerTypeHierarchyAdapter(LootCondition.class, (Object)new LootConditionManager.Serializer()).registerTypeHierarchyAdapter(LootContext.EntityTarget.class, (Object)new LootContext.EntityTarget.Serializer()).create();
    public static Random random = new Random();
    public static String[] nbtHashVariables = new String[]{"#luckySwordEnchantments", "#luckyAxeEnchantments", "#luckyToolEnchantments", "#luckyHelmetEnchantments", "#luckyLeggingsEnchantments", "#luckyBootsEnchantments", "#luckyBowEnchantments", "#luckyFishingRodEnchantments", "#randEnchantment", "#luckyPotionEffects", "#unluckyPotionEffects", "#randFireworksRocket", "#randLaunchMotion", "#motionFromDirection", "#bowMotion", "#chestLootTable", "#customChestLootTable"};

    public static NBTTagCompound getEnchantment(int id, int maxLevel) {
        NBTTagCompound nbttag = new NBTTagCompound();
        nbttag.func_74777_a("id", (short)id);
        nbttag.func_74777_a("lvl", (short)maxLevel);
        return nbttag;
    }

    public static NBTTagCompound getPotionEffect(int id, int amplifier, int duration) {
        NBTTagCompound nbttag = new NBTTagCompound();
        nbttag.func_74774_a("Id", (byte)id);
        nbttag.func_74774_a("Amplifier", (byte)amplifier);
        nbttag.func_74768_a("Duration", duration);
        return nbttag;
    }

    public static ArrayList<NBTTagCompound> getRandomList(int minAmount, int maxAmount, NBTTagCompound ... elements) {
        int amountToRemove = elements.length - (random.nextInt(maxAmount + 1 - minAmount) + minAmount);
        ArrayList<NBTTagCompound> chosenElementList = new ArrayList<NBTTagCompound>(elements.length);
        for (NBTTagCompound element : elements) {
            chosenElementList.add(element.func_74737_b());
        }
        for (int a = 0; a < amountToRemove; ++a) {
            int index = random.nextInt(chosenElementList.size());
            chosenElementList.remove(index);
        }
        return chosenElementList;
    }

    public static NBTTagList getRandomEnchantmentList(int minAmount, int maxAmount, NBTTagCompound ... enchantments) {
        ArrayList<NBTTagCompound> chosenEnchantments = CustomNBTTags.getRandomList(minAmount, maxAmount, enchantments);
        NBTTagList nbttaglist = new NBTTagList();
        for (NBTTagCompound enchantment : chosenEnchantments) {
            enchantment.func_74777_a("lvl", (short)(random.nextInt(enchantment.func_74765_d("lvl")) + 1));
            nbttaglist.func_74742_a((NBTBase)enchantment);
        }
        return nbttaglist;
    }

    public static NBTTagList getRandomPotionEffectList(int minAmount, int maxAmount, NBTTagCompound ... potionEffects) {
        ArrayList<NBTTagCompound> chosenPotionEffects = CustomNBTTags.getRandomList(minAmount, maxAmount, potionEffects);
        NBTTagList nbttaglist = new NBTTagList();
        for (NBTTagCompound potionEffect : chosenPotionEffects) {
            potionEffect.func_74774_a("Amplifier", (byte)random.nextInt(potionEffect.func_74771_c("Amplifier") + 1));
            int minDuration = (int)((float)potionEffect.func_74762_e("Duration") / 3.0f);
            potionEffect.func_74768_a("Duration", random.nextInt(potionEffect.func_74762_e("Duration") + 1 - minDuration) + minDuration);
            nbttaglist.func_74742_a((NBTBase)potionEffect);
        }
        return nbttaglist;
    }

    public static NBTBase getNBTTagFromString(String name, DropProcessData processData) {
        if (name.equals("#luckySwordEnchantments")) {
            return CustomNBTTags.getRandomEnchantmentList(4, 6, sharpness, smite, baneOfArthroponds, knockBack, fireAspect, looting, unbreaking);
        }
        if (name.equals("#luckyAxeEnchantments")) {
            return CustomNBTTags.getRandomEnchantmentList(4, 6, sharpness, smite, baneOfArthroponds, efficiency, unbreaking, fortune);
        }
        if (name.equals("#luckyToolEnchantments")) {
            return CustomNBTTags.getRandomEnchantmentList(2, 3, efficiency, unbreaking, fortune);
        }
        if (name.equals("#luckyHelmetEnchantments")) {
            return CustomNBTTags.getRandomEnchantmentList(4, 6, protection, fireProtection, blastProtection, projectileProtection, respiration, aquaAffinity, unbreaking);
        }
        if (name.equals("#luckyChestplateEnchantments")) {
            return CustomNBTTags.getRandomEnchantmentList(4, 6, protection, fireProtection, blastProtection, projectileProtection, thorns, unbreaking);
        }
        if (name.equals("#luckyLeggingsEnchantments")) {
            return CustomNBTTags.getRandomEnchantmentList(4, 6, protection, fireProtection, blastProtection, projectileProtection, thorns, unbreaking);
        }
        if (name.equals("#luckyBootsEnchantments")) {
            return CustomNBTTags.getRandomEnchantmentList(4, 6, protection, fireProtection, featherFalling, blastProtection, projectileProtection, thorns, unbreaking);
        }
        if (name.equals("#luckyBowEnchantments")) {
            return CustomNBTTags.getRandomEnchantmentList(3, 5, unbreaking, power, punch, flame, infinity);
        }
        if (name.equals("#luckyFishingRodEnchantments")) {
            return CustomNBTTags.getRandomEnchantmentList(2, 3, unbreaking, luckOfTheSea, lure);
        }
        if (name.equals("#randEnchantment")) {
            return CustomNBTTags.getRandomEnchantmentList(1, 1, protection, fireProtection, featherFalling, blastProtection, projectileProtection, thorns, sharpness, smite, baneOfArthroponds, knockBack, fireAspect, looting, efficiency, silkTouch, unbreaking, fortune, power, punch, flame, infinity, luckOfTheSea, lure);
        }
        if (name.equals("#luckyPotionEffects")) {
            return CustomNBTTags.getRandomPotionEffectList(7, 10, speed, haste, strength, instantHealth, jumpBoost, regeneration, resistance, fireResistance, waterBreathing, invisibility, nightVision, healthBoost, absorbtion, saturation);
        }
        if (name.equals("#unluckyPotionEffects")) {
            return CustomNBTTags.getRandomPotionEffectList(5, 7, slowness, miningFatigue, instantDamage, nausea, blindness, hunger, weakness, poison, wither);
        }
        if (name.equals("#randFireworksRocket")) {
            return LuckyFunction.getRandomFireworksRocket();
        }
        if (name.startsWith("#randLaunchMotion")) {
            try {
                float launchPower = 0.9f;
                int launchAngle = 15;
                if (name.startsWith("#randLaunchMotion(")) {
                    String contents = name.substring(name.indexOf(40) + 1, name.lastIndexOf(41));
                    String[] splitValue = DropStringUtils.splitBracketString(contents, ',');
                    splitValue[0] = DropStringUtils.removeNumSuffix(splitValue[0]);
                    launchPower = ValueParser.getFloat(splitValue[0], processData).floatValue();
                    launchAngle = ValueParser.getInteger(splitValue[1], processData);
                }
                float launchYaw = MathHelper.func_76142_g((float)(random.nextFloat() * 360.0f));
                float launchPitch = -90.0f + (float)(random.nextInt(launchAngle * 2) - launchAngle);
                float launchMotionX = -MathHelper.func_76126_a((float)(launchYaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(launchPitch / 180.0f * (float)Math.PI)) * launchPower;
                float launchMotionZ = MathHelper.func_76134_b((float)(launchYaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(launchPitch / 180.0f * (float)Math.PI)) * launchPower;
                float launchMotionY = -MathHelper.func_76126_a((float)(launchPitch / 180.0f * (float)Math.PI)) * launchPower;
                NBTTagList motionList = new NBTTagList();
                motionList.func_74742_a((NBTBase)new NBTTagDouble((double)launchMotionX));
                motionList.func_74742_a((NBTBase)new NBTTagDouble((double)launchMotionY));
                motionList.func_74742_a((NBTBase)new NBTTagDouble((double)launchMotionZ));
                return motionList;
            }
            catch (Exception launchPower) {
                // empty catch block
            }
        }
        if (name.startsWith("#motionFromDirection(")) {
            try {
                String contents = name.substring(name.indexOf(40) + 1, name.lastIndexOf(41));
                String[] splitValue = DropStringUtils.splitBracketString(contents, ',');
                splitValue[2] = DropStringUtils.removeNumSuffix(splitValue[2]);
                int launchYaw = ValueParser.getInteger(splitValue[0], processData);
                int launchPitch = ValueParser.getInteger(splitValue[1], processData);
                float launchPower = ValueParser.getFloat(splitValue[2], processData).floatValue();
                float launchMotionX = -MathHelper.func_76126_a((float)((float)launchYaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)((float)launchPitch / 180.0f * (float)Math.PI)) * launchPower;
                float launchMotionZ = MathHelper.func_76134_b((float)((float)launchYaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)((float)launchPitch / 180.0f * (float)Math.PI)) * launchPower;
                float launchMotionY = -MathHelper.func_76126_a((float)((float)launchPitch / 180.0f * (float)Math.PI)) * launchPower;
                NBTTagList motionList = new NBTTagList();
                motionList.func_74742_a((NBTBase)new NBTTagDouble((double)launchMotionX));
                motionList.func_74742_a((NBTBase)new NBTTagDouble((double)launchMotionY));
                motionList.func_74742_a((NBTBase)new NBTTagDouble((double)launchMotionZ));
                return motionList;
            }
            catch (Exception contents) {
                // empty catch block
            }
        }
        if (name.startsWith("#bowMotion")) {
            try {
                Entity shooter;
                float bowPowerMod = 1.0f;
                float randAngle = 0.0f;
                if (name.startsWith("#bowMotion(")) {
                    String contents = name.substring(name.indexOf(40) + 1, name.lastIndexOf(41));
                    String[] splitValue = DropStringUtils.splitBracketString(contents, ',');
                    splitValue[0] = DropStringUtils.removeNumSuffix(splitValue[0]);
                    if (splitValue.length > 1) {
                        splitValue[1] = DropStringUtils.removeNumSuffix(splitValue[1]);
                    }
                    bowPowerMod = ValueParser.getFloat(splitValue[0], processData).floatValue();
                    if (splitValue.length > 1) {
                        randAngle = ValueParser.getFloat(splitValue[1], processData).floatValue();
                    }
                }
                EntityTippedArrow entityArrow = (shooter = processData.getPlayer()) instanceof EntityLivingBase ? new EntityTippedArrow(processData.getWorld(), (EntityLivingBase)shooter) : new EntityTippedArrow(processData.getWorld(), shooter.field_70165_t, shooter.field_70163_u, shooter.field_70161_v);
                entityArrow.func_184547_a(shooter, shooter.field_70125_A + HashVariables.randomFloatClamp(processData.getWorld().field_73012_v, -randAngle, randAngle), shooter.field_70177_z + HashVariables.randomFloatClamp(processData.getWorld().field_73012_v, -randAngle, randAngle), 0.0f, processData.getBowPower(), 1.0f);
                NBTTagList motionList = new NBTTagList();
                motionList.func_74742_a((NBTBase)new NBTTagDouble(entityArrow.field_70159_w));
                motionList.func_74742_a((NBTBase)new NBTTagDouble(entityArrow.field_70181_x));
                motionList.func_74742_a((NBTBase)new NBTTagDouble(entityArrow.field_70179_y));
                return motionList;
            }
            catch (Exception bowPowerMod) {
                // empty catch block
            }
        }
        name = name.replace("#chestVillageBlacksmith", "#chestLootTable(" + LootTableList.field_186423_e.func_110623_a() + ")");
        name = name.replace("#chestBonusChest", "#chestLootTable(" + LootTableList.field_186420_b.func_110623_a() + ")");
        if ((name = name.replace("#chestDungeonChest", "#chestLootTable(" + LootTableList.field_186422_d.func_110623_a() + ")")).startsWith("#customChestLootTable(")) {
            try {
                String contents = ValueParser.getString(name.substring(name.indexOf(40) + 1, name.lastIndexOf(41)));
                LootTable.Serializer serializer = new LootTable.Serializer();
                LootTable lootTable = ForgeHooks.loadLootTable((Gson)GSON_INSTANCE, (ResourceLocation)LootTableList.field_186420_b, (String)contents, (boolean)true, (LootTableManager)processData.getWorld().func_184146_ak());
                TileEntityChest tileEntityChest = new TileEntityChest();
                LootContext.Builder contextBuilder = new LootContext.Builder((WorldServer)processData.getWorld());
                if (processData.getPlayer() != null && processData.getPlayer() instanceof EntityPlayer) {
                    contextBuilder.func_186469_a(((EntityPlayer)processData.getPlayer()).func_184817_da());
                }
                lootTable.func_186460_a((IInventory)tileEntityChest, random, contextBuilder.func_186471_a());
                NBTTagCompound tagCompound = new NBTTagCompound();
                tileEntityChest.func_189515_b(tagCompound);
                return tagCompound.func_150295_c("Items", 10);
            }
            catch (Exception e) {
                System.err.println("Lucky Block: Error creating chest from .json loot table");
                e.printStackTrace();
            }
        }
        if (name.startsWith("#chestLootTable(")) {
            TileEntityChest tileEntityChest = new TileEntityChest();
            String lootId = ValueParser.getString(name.substring(name.indexOf(40) + 1, name.lastIndexOf(41)));
            tileEntityChest.func_145834_a(processData.getWorld());
            tileEntityChest.func_189404_a(new ResourceLocation("minecraft", lootId), random.nextLong());
            tileEntityChest.func_70301_a(0);
            NBTTagCompound tagCompound = new NBTTagCompound();
            tileEntityChest.func_189515_b(tagCompound);
            return tagCompound.func_150295_c("Items", 10);
        }
        return null;
    }
}

