/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.world.gen.feature;

import java.util.HashSet;
import java.util.Random;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import org.jetbrains.annotations.NotNull;
import thedarkcolour.futuremc.block.villagepillage.BlockBamboo;
import thedarkcolour.futuremc.registry.FBlocks;
import thedarkcolour.futuremc.world.gen.feature.FWorldGen;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\"\u0010\u0003\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lthedarkcolour/futuremc/world/gen/feature/BambooWorldGen;", "Lthedarkcolour/futuremc/world/gen/feature/FWorldGen;", "()V", "VALID_BIOMES", "Ljava/util/HashSet;", "Lnet/minecraft/util/ResourceLocation;", "Lkotlin/collections/HashSet;", "generate", "", "rand", "Ljava/util/Random;", "chunkX", "", "chunkZ", "worldIn", "Lnet/minecraft/world/World;", "chunkGenerator", "Lnet/minecraft/world/gen/IChunkGenerator;", "chunkProvider", "Lnet/minecraft/world/chunk/IChunkProvider;", "random", "pos", "Lnet/minecraft/util/math/BlockPos;", "isBiomeValid", "", "biome", "Lnet/minecraft/world/biome/Biome;", "Future-MC"})
@SourceDebugExtension(value={"SMAP\nBambooWorldGen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BambooWorldGen.kt\nthedarkcolour/futuremc/world/gen/feature/BambooWorldGen\n+ 2 FWorldGen.kt\nthedarkcolour/futuremc/world/gen/feature/FWorldGen$Companion\n*L\n1#1,61:1\n66#2,8:62\n*E\n*S KotlinDebug\n*F\n+ 1 BambooWorldGen.kt\nthedarkcolour/futuremc/world/gen/feature/BambooWorldGen\n*L\n52#1,8:62\n*E\n"})
public final class BambooWorldGen
implements FWorldGen {
    private static final HashSet<ResourceLocation> VALID_BIOMES;
    @NotNull
    public static final BambooWorldGen INSTANCE;

    /*
     * WARNING - void declaration
     */
    private final void generate(World worldIn, Random random, BlockPos pos) {
        BlockBamboo bamboo;
        block6: {
            block5: {
                bamboo = FBlocks.BAMBOO;
                IBlockState iBlockState = worldIn.func_180495_p(pos);
                Intrinsics.checkNotNullExpressionValue((Object)iBlockState, (String)"worldIn.getBlockState(pos)");
                Block block = iBlockState.func_177230_c();
                if (!block.func_176200_f((IBlockAccess)worldIn, pos) || !bamboo.func_176196_c(worldIn, pos)) break block5;
                Biome biome = worldIn.func_180494_b(pos);
                Intrinsics.checkNotNullExpressionValue((Object)biome, (String)"worldIn.getBiome(pos)");
                if (this.isBiomeValid(biome)) break block6;
            }
            return;
        }
        worldIn.func_175656_a(pos, bamboo.func_176223_P());
        int n = 0;
        int n2 = 9;
        while (n <= n2) {
            void j;
            IBlockState iBlockState = worldIn.func_180495_p(pos);
            Intrinsics.checkNotNullExpressionValue((Object)iBlockState, (String)"worldIn.getBlockState(pos)");
            if (Intrinsics.areEqual((Object)iBlockState.func_177230_c(), (Object)((Object)bamboo)) && bamboo.func_176473_a(worldIn, pos, worldIn.func_180495_p(pos), false)) {
                IBlockState iBlockState2 = worldIn.func_180495_p(pos);
                Intrinsics.checkNotNullExpressionValue((Object)iBlockState2, (String)"worldIn.getBlockState(pos)");
                bamboo.func_176474_b(worldIn, random, pos, iBlockState2);
            }
            ++j;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void generate(@NotNull Random rand, int chunkX, int chunkZ, @NotNull World worldIn, @NotNull IChunkGenerator chunkGenerator, @NotNull IChunkProvider chunkProvider) {
        Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)chunkGenerator, (String)"chunkGenerator");
        Intrinsics.checkNotNullParameter((Object)chunkProvider, (String)"chunkProvider");
        int x = (chunkX << 4) + 8;
        int z = (chunkZ << 4) + 8;
        BlockPos position = new BlockPos(x, 0, z);
        Biome biome = worldIn.getBiomeForCoordsBody(position);
        Chunk chunk = worldIn.func_72964_e(chunkX, chunkZ);
        Intrinsics.checkNotNullExpressionValue((Object)chunk, (String)"worldIn.getChunk(chunkX, chunkZ)");
        ChunkPos chunkPos = chunk.func_76632_l();
        Biome biome2 = biome;
        Intrinsics.checkNotNullExpressionValue((Object)biome2, (String)"biome");
        if (this.isBiomeValid(biome2) && Intrinsics.areEqual((Object)worldIn.func_175624_G(), (Object)WorldType.field_77138_c) ^ true) {
            FWorldGen.Companion companion = FWorldGen.Companion;
            ChunkPos chunkPos2 = chunkPos;
            Intrinsics.checkNotNullExpressionValue((Object)chunkPos2, (String)"chunkPos");
            ChunkPos chunkPos3 = chunkPos2;
            int n = 0;
            IntRange tries$iv = new IntRange(n, 22);
            boolean $i$f$placeAround = false;
            IntRange intRange = tries$iv;
            int n2 = intRange.getFirst();
            int n3 = intRange.getLast();
            if (n2 <= n3) {
                while (true) {
                    void i$iv;
                    void pos;
                    void random;
                    void chunkPos$iv;
                    int xPos$iv = rand.nextInt(16) + 8;
                    int zPos$iv = rand.nextInt(16) + 8;
                    BlockPos blockPos = worldIn.func_175645_m(chunkPos$iv.func_180331_a(0, 0, 0).func_177982_a(xPos$iv, 0, zPos$iv));
                    Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldIn.getHeight(chunkP\u20260, 0).add(xPos, 0, zPos))");
                    int yPos$iv = rand.nextInt(blockPos.func_177956_o() + 32);
                    BlockPos pos$iv = chunkPos$iv.func_180331_a(0, 0, 0).func_177982_a(xPos$iv, yPos$iv, zPos$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)pos$iv, (String)"pos");
                    Random random2 = rand;
                    World world2 = worldIn;
                    boolean bl = false;
                    INSTANCE.generate(world2, (Random)random, (BlockPos)pos);
                    if (i$iv == n3) break;
                    ++i$iv;
                }
            }
        }
    }

    private final boolean isBiomeValid(Biome biome) {
        return VALID_BIOMES.contains(biome.getRegistryName());
    }

    private BambooWorldGen() {
    }

    static {
        BambooWorldGen bambooWorldGen;
        INSTANCE = bambooWorldGen = new BambooWorldGen();
        Object[] objectArray = new ResourceLocation[5];
        Biome biome = Biomes.field_76782_w;
        Intrinsics.checkNotNullExpressionValue((Object)biome, (String)"Biomes.JUNGLE");
        objectArray[0] = biome.getRegistryName();
        Biome biome2 = Biomes.field_150574_L;
        Intrinsics.checkNotNullExpressionValue((Object)biome2, (String)"Biomes.JUNGLE_EDGE");
        objectArray[1] = biome2.getRegistryName();
        Biome biome3 = Biomes.field_76792_x;
        Intrinsics.checkNotNullExpressionValue((Object)biome3, (String)"Biomes.JUNGLE_HILLS");
        objectArray[2] = biome3.getRegistryName();
        Biome biome4 = Biomes.field_185446_X;
        Intrinsics.checkNotNullExpressionValue((Object)biome4, (String)"Biomes.MUTATED_JUNGLE");
        objectArray[3] = biome4.getRegistryName();
        Biome biome5 = Biomes.field_185447_Y;
        Intrinsics.checkNotNullExpressionValue((Object)biome5, (String)"Biomes.MUTATED_JUNGLE_EDGE");
        objectArray[4] = biome5.getRegistryName();
        VALID_BIOMES = SetsKt.hashSetOf((Object[])objectArray);
    }
}

