/*
 * Decompiled with CFR 0.152.
 */
package superbas11.menumobs;

import java.io.File;
import java.util.ArrayList;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import superbas11.menumobs.ConfigElements;
import superbas11.menumobs.MainMenuRenderTicker;
import superbas11.menumobs.Reference;
import superbas11.menumobs.gui.BlacklistArrayEntry;
import superbas11.menumobs.gui.FixedMobEntry;
import superbas11.menumobs.gui.VolumeSliderEntry;

@Mod(modid="menumobs", name="Menu Mobs", version="1.21", useMetadata=true, clientSideOnly=true, acceptableRemoteVersions="*", guiFactory="superbas11.menumobs.gui.ModGuiFactoryHandler", acceptedMinecraftVersions="[1.12]")
public class MenuMobs {
    @Mod.Instance(value="menumobs")
    public static MenuMobs instance;
    public boolean showMainMenuMobs = true;
    public MainMenuRenderTicker mainMenuTicker;
    public boolean showOnlyPlayerModels;
    public double mobSoundVolume;
    public String[] fixedMob;
    public Property blacklist;
    public boolean allowDebugOutput;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        File file = event.getSuggestedConfigurationFile();
        Reference.config = new Configuration(file);
        this.syncConfig();
    }

    public void syncConfig() {
        String ctgyGen = "general";
        Reference.config.load();
        Reference.config.setCategoryComment(ctgyGen, "ATTENTION: Editing this file manually is no longer necessary. \nOn the Mods list screen select the entry for menumobs, then click the Config button to modify these settings.");
        ArrayList<String> orderedKeys = new ArrayList<String>(ConfigElements.values().length);
        this.showMainMenuMobs = Reference.config.getBoolean(ConfigElements.SHOW_MAIN_MENU_MOBS.key(), ctgyGen, true, ConfigElements.SHOW_MAIN_MENU_MOBS.desc(), ConfigElements.SHOW_MAIN_MENU_MOBS.languageKey());
        orderedKeys.add(ConfigElements.SHOW_MAIN_MENU_MOBS.key());
        this.showOnlyPlayerModels = Reference.config.getBoolean(ConfigElements.SHOW_ONLY_PLAYER_MODELS.key(), ctgyGen, false, ConfigElements.SHOW_ONLY_PLAYER_MODELS.desc(), ConfigElements.SHOW_ONLY_PLAYER_MODELS.languageKey());
        orderedKeys.add(ConfigElements.SHOW_ONLY_PLAYER_MODELS.key());
        this.mobSoundVolume = Reference.config.get(ctgyGen, ConfigElements.MOB_SOUNDS_VOLUME.key(), 0.5, ConfigElements.MOB_SOUNDS_VOLUME.desc(), 0.0, 1.0).setConfigEntryClass(VolumeSliderEntry.class).getDouble();
        orderedKeys.add(ConfigElements.MOB_SOUNDS_VOLUME.key());
        this.fixedMob = Reference.config.get(ctgyGen, ConfigElements.FIXED_MOB.key(), new String[0], ConfigElements.FIXED_MOB.desc(), Property.Type.STRING).setConfigEntryClass(FixedMobEntry.class).getStringList();
        orderedKeys.add(ConfigElements.FIXED_MOB.key());
        this.blacklist = Reference.config.get(ctgyGen, ConfigElements.BLACKLIST.key(), new String[0], ConfigElements.BLACKLIST.desc(), Property.Type.STRING).setArrayEntryClass(BlacklistArrayEntry.class);
        orderedKeys.add(ConfigElements.BLACKLIST.key());
        this.allowDebugOutput = Reference.config.getBoolean(ConfigElements.ALLOW_DEBUG_OUTPUT.key(), ctgyGen, false, ConfigElements.SHOW_MAIN_MENU_MOBS.desc(), ConfigElements.ALLOW_DEBUG_OUTPUT.languageKey());
        orderedKeys.add(ConfigElements.ALLOW_DEBUG_OUTPUT.key());
        Reference.config.setCategoryPropertyOrder(ctgyGen, orderedKeys);
        Reference.config.save();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)instance);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        this.mainMenuTicker = new MainMenuRenderTicker();
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("menumobs")) {
            Reference.config.save();
            this.syncConfig();
        }
    }

    @SubscribeEvent
    public void onGuiOpen(GuiOpenEvent event) {
        if (this.showMainMenuMobs) {
            if (this.mainMenuTicker.isMainMenu(event.getGui())) {
                this.mainMenuTicker.register();
            } else if (this.mainMenuTicker.isRegistered()) {
                this.mainMenuTicker.unRegister();
            }
        }
    }
}

