/*
 * Decompiled with CFR 0.152.
 */
package superhb.arcademod.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import superhb.arcademod.Arcade;
import superhb.arcademod.network.ClientCoinMessage;
import superhb.arcademod.util.ArcadePacketHandler;

public class ServerCoinMessage
implements IMessage {
    private int cost;
    private ItemStack stack;

    public ServerCoinMessage() {
    }

    public ServerCoinMessage(ItemStack stack, int cost) {
        this.cost = cost;
        this.stack = stack;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.cost);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.stack);
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.cost = buf.readInt();
            this.stack = ByteBufUtils.readItemStack((ByteBuf)buf);
        }
        catch (Exception e) {
            Arcade.logger.info("Error: " + e);
        }
    }

    public int getCost() {
        return this.cost;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public static class Handler
    implements IMessageHandler<ServerCoinMessage, IMessage> {
        public IMessage onMessage(ServerCoinMessage message, MessageContext context) {
            WorldServer thread = (WorldServer)context.getServerHandler().field_147369_b.field_70170_p;
            thread.func_152344_a(() -> {
                EntityPlayerMP serverPlayer = context.getServerHandler().field_147369_b;
                ArrayList<int[]> slotIndexes = new ArrayList<int[]>();
                int totalCount = 0;
                if (serverPlayer.field_71071_by.func_70431_c(message.getStack())) {
                    for (int i = 0; i < serverPlayer.field_71071_by.func_70302_i_(); ++i) {
                        if (!serverPlayer.field_71071_by.func_70301_a(i).func_77973_b().equals(message.getStack().func_77973_b())) continue;
                        totalCount += serverPlayer.field_71071_by.func_70301_a(i).func_190916_E();
                        slotIndexes.add(new int[]{i, serverPlayer.field_71071_by.func_70301_a(i).func_190916_E()});
                    }
                    if (totalCount < message.getCost()) {
                        ArcadePacketHandler.INSTANCE.sendTo((IMessage)new ClientCoinMessage(false, -1), serverPlayer);
                    } else if (totalCount == message.getCost()) {
                        for (int[] i : slotIndexes) {
                            serverPlayer.field_71071_by.func_70304_b(i[0]);
                        }
                        ArcadePacketHandler.INSTANCE.sendTo((IMessage)new ClientCoinMessage(true, 0), serverPlayer);
                    } else if (totalCount > message.getCost()) {
                        int useSlot;
                        if (message.getCost() < 64) {
                            useSlot = 0;
                            for (int i = 0; i < slotIndexes.size(); ++i) {
                                if (((int[])slotIndexes.get(i))[1] < message.getCost()) continue;
                                useSlot = ((int[])slotIndexes.get(i))[0];
                            }
                            serverPlayer.field_71071_by.func_70298_a(useSlot, message.getCost());
                        } else if (message.getCost() == 64) {
                            useSlot = 0;
                            for (int i = 0; i < slotIndexes.size(); ++i) {
                                if (((int[])slotIndexes.get(i))[1] < message.getCost()) continue;
                                useSlot = ((int[])slotIndexes.get(i))[0];
                            }
                            serverPlayer.field_71071_by.func_70304_b(useSlot);
                        } else if (message.getCost() > 64) {
                            int i;
                            int stacks;
                            int j = 0;
                            float stacksf = (float)message.getCost() / 64.0f;
                            float remainder = (stacksf - (float)(stacks = message.getCost() / 64)) * 64.0f;
                            int[] useSlot2 = remainder == 0.0f ? new int[stacks] : new int[stacks + 1];
                            for (i = 0; i < slotIndexes.size(); ++i) {
                                if (j >= useSlot2.length) continue;
                                if (((int[])slotIndexes.get(i))[i] == 64) {
                                    useSlot2[j] = ((int[])slotIndexes.get(i))[0];
                                } else if (remainder > 0.0f && (float)((int[])slotIndexes.get(i))[1] >= remainder) {
                                    useSlot2[j] = ((int[])slotIndexes.get(i))[0];
                                }
                                ++j;
                            }
                            for (i = 0; i < useSlot2.length; ++i) {
                                if (remainder == 0.0f) {
                                    serverPlayer.field_71071_by.func_70304_b(useSlot2[i]);
                                    continue;
                                }
                                if (i < useSlot2.length - 1) {
                                    serverPlayer.field_71071_by.func_70304_b(useSlot2[i]);
                                    continue;
                                }
                                if (i >= useSlot2.length) continue;
                                serverPlayer.field_71071_by.func_70298_a(useSlot2[i], (int)remainder);
                            }
                        }
                        ArcadePacketHandler.INSTANCE.sendTo((IMessage)new ClientCoinMessage(true, 0), serverPlayer);
                    }
                } else {
                    ArcadePacketHandler.INSTANCE.sendTo((IMessage)new ClientCoinMessage(false, -1), serverPlayer);
                }
            });
            return null;
        }
    }
}

