/*
 * Decompiled with CFR 0.152.
 */
package superhb.arcademod.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import superhb.arcademod.client.tileentity.TileEntityArcade;

public class ServerSoundMessage
implements IMessage {
    private String soundName;
    private int x;
    private int y;
    private int z;
    private float volume;
    private boolean loop;
    private boolean play;

    public ServerSoundMessage() {
    }

    public ServerSoundMessage(ResourceLocation resource, BlockPos pos, float volume, boolean loop, boolean play) {
        this.soundName = resource.func_110623_a();
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
        this.volume = volume;
        this.loop = loop;
        this.play = play;
    }

    public ServerSoundMessage(String name, BlockPos pos, float volume, boolean loop, boolean play) {
        this.soundName = name;
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
        this.volume = volume;
        this.loop = loop;
        this.play = play;
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.soundName);
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeFloat(this.volume);
        buf.writeBoolean(this.loop);
        buf.writeBoolean(this.play);
    }

    public void fromBytes(ByteBuf buf) {
        this.soundName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.volume = buf.readFloat();
        this.loop = buf.readBoolean();
        this.play = buf.readBoolean();
    }

    public ResourceLocation getResourceLocation() {
        return new ResourceLocation("arcademod", this.soundName);
    }

    public BlockPos getBlockPos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public boolean isLooping() {
        return this.loop;
    }

    public boolean play() {
        return this.play;
    }

    public float getVolume() {
        return this.volume;
    }

    public static class Handler
    implements IMessageHandler<ServerSoundMessage, IMessage> {
        public IMessage onMessage(ServerSoundMessage message, MessageContext context) {
            WorldServer thread = (WorldServer)context.getServerHandler().field_147369_b.field_70170_p;
            thread.func_152344_a(() -> {
                World world = context.getServerHandler().field_147369_b.field_70170_p;
                TileEntity entity = world.func_175625_s(message.getBlockPos());
                if (entity instanceof TileEntityArcade) {
                    TileEntityArcade arcade = (TileEntityArcade)world.func_175625_s(message.getBlockPos());
                    if (message.play()) {
                        arcade.playSound(message.getResourceLocation(), message.getVolume(), message.isLooping());
                    } else {
                        arcade.stop();
                    }
                }
            });
            return null;
        }
    }
}

