/*
 * Decompiled with CFR 0.152.
 */
package uk.kihira.tails.common;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import uk.kihira.tails.common.PartInfo;
import uk.kihira.tails.common.PartsData;
import uk.kihira.tails.common.Tails;

class PartsDataDeserializer
implements JsonDeserializer<PartsData> {
    PartsDataDeserializer() {
    }

    public PartsData deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.getAsJsonObject().has("partInfos")) {
            PartsData partsData = new PartsData();
            for (JsonElement e : json.getAsJsonObject().get("partInfos").getAsJsonArray()) {
                PartInfo info = (PartInfo)context.deserialize(e, PartInfo.class);
                partsData.partInfoMap.put(info.partType, info);
            }
            Tails.logger.info("Loading old parts data");
            return partsData;
        }
        return (PartsData)new Gson().fromJson(json, typeOfT);
    }
}

