/*
 * Decompiled with CFR 0.152.
 */
package uk.kihira.tails.common;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.util.Map;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.NetworkCheckHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import net.minecraftforge.fml.common.versioning.DefaultArtifactVersion;
import net.minecraftforge.fml.common.versioning.VersionParser;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import uk.kihira.tails.common.PartInfo;
import uk.kihira.tails.common.PartsData;
import uk.kihira.tails.common.PartsDataDeserializer;
import uk.kihira.tails.proxy.CommonProxy;

@Mod(modid="tails", name="Tails", version="1.12-1.10.0", dependencies="after:moreplayermodels", acceptedMinecraftVersions="[1.12]")
public class Tails {
    public static final String MOD_ID = "tails";
    public static final Logger logger = LogManager.getLogger((String)"tails");
    public static final SimpleNetworkWrapper networkWrapper = NetworkRegistry.INSTANCE.newSimpleChannel("tails");
    public static final Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().registerTypeAdapter(PartsData.class, (Object)new PartsDataDeserializer()).create();
    public static Configuration configuration;
    public static boolean libraryEnabled;
    public static boolean hasRemote;
    @SidedProxy(clientSide="uk.kihira.tails.proxy.ClientProxy", serverSide="uk.kihira.tails.proxy.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="tails")
    public static Tails instance;
    public static PartsData localPartsData;

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent e) {
        proxy.init();
        if (e.getSide().isClient()) {
            configuration = new Configuration(e.getSuggestedConfigurationFile());
            this.loadConfig();
        }
    }

    @Mod.EventHandler
    public void onPostInit(FMLPostInitializationEvent e) {
        proxy.registerRenderers();
    }

    @SubscribeEvent
    public void onConfigChange(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(MOD_ID)) {
            this.loadConfig();
        }
    }

    @NetworkCheckHandler
    public boolean checkRemoteVersions(Map<String, String> versions, Side side) {
        if (versions.containsKey(MOD_ID)) {
            String clientVer = ((ModContainer)Loader.instance().getReversedModObjectList().get((Object)this)).getVersion();
            if (!VersionParser.parseRange((String)("[" + clientVer + ",)")).containsVersion((ArtifactVersion)new DefaultArtifactVersion(versions.get(MOD_ID)))) {
                logger.warn(String.format("Remote version not in acceptable version bounds! Local is %s, Remote (%s) is %s", clientVer, side.toString(), versions.get(MOD_ID)));
            } else {
                logger.debug(String.format("Remote version is in acceptable version bounds. Local is %s, Remote (%s) is %s", clientVer, side.toString(), versions.get(MOD_ID)));
                hasRemote = true;
            }
        }
        return true;
    }

    public void loadConfig() {
        try {
            localPartsData = (PartsData)gson.fromJson(configuration.getString("Local Player Data", "general", "{}", "Local Players data. Delete to remove all customisation data. Do not try to edit manually"), PartsData.class);
            PartInfo tailInfo = null;
            if (configuration.hasKey("general", "Local Tail Info")) {
                tailInfo = (PartInfo)gson.fromJson(configuration.getString("Local Tail Info", "general", "DEPRECIATED. CAN SAFELY REMOVE", ""), PartInfo.class);
            }
            if (tailInfo != null) {
                if (localPartsData == null) {
                    localPartsData = new PartsData();
                }
                tailInfo.partType = PartsData.PartType.TAIL;
                localPartsData.setPartInfo(PartsData.PartType.TAIL, tailInfo);
                Property prop = configuration.get("general", "Local Tail Info", "");
                prop.set("");
                Tails.setLocalPartsData(localPartsData);
            }
            if (localPartsData == null) {
                localPartsData = new PartsData();
                for (PartsData.PartType partType : PartsData.PartType.values()) {
                    localPartsData.setPartInfo(partType, PartInfo.none(partType));
                }
                Tails.setLocalPartsData(localPartsData);
            }
        }
        catch (JsonSyntaxException e) {
            configuration.getCategory("general").remove((Object)"Local Player Data");
            logger.error("Failed to load local player data: Invalid JSON syntax! Invalid data being removed");
        }
        libraryEnabled = configuration.getBoolean("Enable Library", "general", true, "Whether to enable the library system for sharing tails. This mostly matters on servers.");
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    public static void setLocalPartsData(PartsData partsData) {
        localPartsData = partsData;
        Property prop = configuration.get("general", "Local Player Data", "");
        prop.set(gson.toJson((Object)localPartsData));
        configuration.save();
    }
}

